package org.openqa.selenium.devtools.v112.storage.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Enum of interest group access types.
 */
public enum InterestGroupAccessType {

    JOIN("join"),
    LEAVE("leave"),
    UPDATE("update"),
    LOADED("loaded"),
    BID("bid"),
    WIN("win");

    private String value;

    InterestGroupAccessType(String value) {
        this.value = value;
    }

    public static InterestGroupAccessType fromString(String s) {
        return java.util.Arrays.stream(InterestGroupAccessType.values()).filter(rs -> rs.value.equalsIgnoreCase(s)).findFirst().orElseThrow(() -> new org.openqa.selenium.devtools.DevToolsException("Given value " + s + " is not found within InterestGroupAccessType "));
    }

    public String toString() {
        return value;
    }

    public String toJson() {
        return value;
    }

    private static InterestGroupAccessType fromJson(JsonInput input) {
        return fromString(input.nextString());
    }
}
