package org.openqa.selenium.devtools.v112.profiler;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import com.google.common.collect.ImmutableMap;
import org.openqa.selenium.json.JsonInput;

public class Profiler {

    public static Command<Void> disable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Profiler.disable", params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Profiler.enable", params.build());
    }

    /**
     * Collect coverage data for the current isolate. The coverage data may be incomplete due to
     * garbage collection.
     */
    public static Command<java.util.List<org.openqa.selenium.devtools.v112.profiler.model.ScriptCoverage>> getBestEffortCoverage() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Profiler.getBestEffortCoverage", params.build(), ConverterFunctions.map("result", new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v112.profiler.model.ScriptCoverage>>() {
        }.getType()));
    }

    /**
     * Changes CPU profiler sampling interval. Must be called before CPU profiles recording started.
     */
    public static Command<Void> setSamplingInterval(java.lang.Integer interval) {
        java.util.Objects.requireNonNull(interval, "interval is required");
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        params.put("interval", interval);
        return new Command<>("Profiler.setSamplingInterval", params.build());
    }

    public static Command<Void> start() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Profiler.start", params.build());
    }

    /**
     * Enable precise code coverage. Coverage data for JavaScript executed before enabling precise code
     * coverage may be incomplete. Enabling prevents running optimized code and resets execution
     * counters.
     */
    public static Command<java.lang.Number> startPreciseCoverage(java.util.Optional<java.lang.Boolean> callCount, java.util.Optional<java.lang.Boolean> detailed, java.util.Optional<java.lang.Boolean> allowTriggeredUpdates) {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        callCount.ifPresent(p -> params.put("callCount", p));
        detailed.ifPresent(p -> params.put("detailed", p));
        allowTriggeredUpdates.ifPresent(p -> params.put("allowTriggeredUpdates", p));
        return new Command<>("Profiler.startPreciseCoverage", params.build(), ConverterFunctions.map("timestamp", java.lang.Number.class));
    }

    public static Command<org.openqa.selenium.devtools.v112.profiler.model.Profile> stop() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Profiler.stop", params.build(), ConverterFunctions.map("profile", org.openqa.selenium.devtools.v112.profiler.model.Profile.class));
    }

    /**
     * Disable precise code coverage. Disabling releases unnecessary execution count records and allows
     * executing optimized code.
     */
    public static Command<Void> stopPreciseCoverage() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Profiler.stopPreciseCoverage", params.build());
    }

    public static class TakePreciseCoverageResponse {

        private final java.util.List<org.openqa.selenium.devtools.v112.profiler.model.ScriptCoverage> result;

        private final java.lang.Number timestamp;

        public TakePreciseCoverageResponse(java.util.List<org.openqa.selenium.devtools.v112.profiler.model.ScriptCoverage> result, java.lang.Number timestamp) {
            this.result = java.util.Objects.requireNonNull(result, "result is required");
            this.timestamp = java.util.Objects.requireNonNull(timestamp, "timestamp is required");
        }

        /**
         * Coverage data for the current isolate.
         */
        public java.util.List<org.openqa.selenium.devtools.v112.profiler.model.ScriptCoverage> getResult() {
            return result;
        }

        /**
         * Monotonically increasing time (in seconds) when the coverage update was taken in the backend.
         */
        public java.lang.Number getTimestamp() {
            return timestamp;
        }

        private static TakePreciseCoverageResponse fromJson(JsonInput input) {
            java.util.List<org.openqa.selenium.devtools.v112.profiler.model.ScriptCoverage> result = null;
            java.lang.Number timestamp = 0;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "result":
                        result = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v112.profiler.model.ScriptCoverage>>() {
                        }.getType());
                        break;
                    case "timestamp":
                        timestamp = input.nextNumber();
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new TakePreciseCoverageResponse(result, timestamp);
        }
    }

    /**
     * Collect coverage data for the current isolate, and resets execution counters. Precise code
     * coverage needs to have started.
     */
    public static Command<org.openqa.selenium.devtools.v112.profiler.Profiler.TakePreciseCoverageResponse> takePreciseCoverage() {
        ImmutableMap.Builder<String, Object> params = ImmutableMap.builder();
        return new Command<>("Profiler.takePreciseCoverage", params.build(), input -> input.read(org.openqa.selenium.devtools.v112.profiler.Profiler.TakePreciseCoverageResponse.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.profiler.model.ConsoleProfileFinished> consoleProfileFinished() {
        return new Event<>("Profiler.consoleProfileFinished", input -> input.read(org.openqa.selenium.devtools.v112.profiler.model.ConsoleProfileFinished.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.profiler.model.ConsoleProfileStarted> consoleProfileStarted() {
        return new Event<>("Profiler.consoleProfileStarted", input -> input.read(org.openqa.selenium.devtools.v112.profiler.model.ConsoleProfileStarted.class));
    }

    public static Event<org.openqa.selenium.devtools.v112.profiler.model.PreciseCoverageDeltaUpdate> preciseCoverageDeltaUpdate() {
        return new Event<>("Profiler.preciseCoverageDeltaUpdate", input -> input.read(org.openqa.selenium.devtools.v112.profiler.model.PreciseCoverageDeltaUpdate.class));
    }
}
