package org.openqa.selenium.devtools.v112.preload.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Corresponds to SpeculationRuleSet
 */
public class RuleSet {

    private final org.openqa.selenium.devtools.v112.preload.model.RuleSetId id;

    private final org.openqa.selenium.devtools.v112.network.model.LoaderId loaderId;

    private final java.lang.String sourceText;

    public RuleSet(org.openqa.selenium.devtools.v112.preload.model.RuleSetId id, org.openqa.selenium.devtools.v112.network.model.LoaderId loaderId, java.lang.String sourceText) {
        this.id = java.util.Objects.requireNonNull(id, "id is required");
        this.loaderId = java.util.Objects.requireNonNull(loaderId, "loaderId is required");
        this.sourceText = java.util.Objects.requireNonNull(sourceText, "sourceText is required");
    }

    public org.openqa.selenium.devtools.v112.preload.model.RuleSetId getId() {
        return id;
    }

    /**
     * Identifies a document which the rule set is associated with.
     */
    public org.openqa.selenium.devtools.v112.network.model.LoaderId getLoaderId() {
        return loaderId;
    }

    /**
     * Source text of JSON representing the rule set. If it comes from
     * `script` tag, it is the textContent of the node. Note that it is
     * a JSON for valid case.
     *
     * See also:
     * - https://wicg.github.io/nav-speculation/speculation-rules.html
     * - https://github.com/WICG/nav-speculation/blob/main/triggers.md
     */
    public java.lang.String getSourceText() {
        return sourceText;
    }

    private static RuleSet fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v112.preload.model.RuleSetId id = null;
        org.openqa.selenium.devtools.v112.network.model.LoaderId loaderId = null;
        java.lang.String sourceText = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "id":
                    id = input.read(org.openqa.selenium.devtools.v112.preload.model.RuleSetId.class);
                    break;
                case "loaderId":
                    loaderId = input.read(org.openqa.selenium.devtools.v112.network.model.LoaderId.class);
                    break;
                case "sourceText":
                    sourceText = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new RuleSet(id, loaderId, sourceText);
    }
}
