/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v108.database;

import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.ConverterFunctions;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.v108.database.model.DatabaseId;
import org.openqa.selenium.devtools.v108.database.model.Error;
import org.openqa.selenium.json.JsonInput;

@Beta
public class Database {
    public static Command<Void> disable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Database.disable", (Map)params.build());
    }

    public static Command<Void> enable() {
        ImmutableMap.Builder params = ImmutableMap.builder();
        return new Command("Database.enable", (Map)params.build());
    }

    public static Command<ExecuteSQLResponse> executeSQL(DatabaseId databaseId, String query) {
        Objects.requireNonNull(databaseId, "databaseId is required");
        Objects.requireNonNull(query, "query is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"databaseId", (Object)databaseId);
        params.put((Object)"query", (Object)query);
        return new Command("Database.executeSQL", (Map)params.build(), input -> (ExecuteSQLResponse)input.read(ExecuteSQLResponse.class));
    }

    public static Command<List<String>> getDatabaseTableNames(DatabaseId databaseId) {
        Objects.requireNonNull(databaseId, "databaseId is required");
        ImmutableMap.Builder params = ImmutableMap.builder();
        params.put((Object)"databaseId", (Object)databaseId);
        return new Command("Database.getDatabaseTableNames", (Map)params.build(), ConverterFunctions.map((String)"tableNames", (Type)new TypeToken<List<String>>(){}.getType()));
    }

    public static Event<org.openqa.selenium.devtools.v108.database.model.Database> addDatabase() {
        return new Event("Database.addDatabase", ConverterFunctions.map((String)"database", org.openqa.selenium.devtools.v108.database.model.Database.class));
    }

    public static class ExecuteSQLResponse {
        private final Optional<List<String>> columnNames;
        private final Optional<List<Object>> values;
        private final Optional<Error> sqlError;

        public ExecuteSQLResponse(Optional<List<String>> columnNames, Optional<List<Object>> values, Optional<Error> sqlError) {
            this.columnNames = columnNames;
            this.values = values;
            this.sqlError = sqlError;
        }

        public Optional<List<String>> getColumnNames() {
            return this.columnNames;
        }

        public Optional<List<Object>> getValues() {
            return this.values;
        }

        public Optional<Error> getSqlError() {
            return this.sqlError;
        }

        private static ExecuteSQLResponse fromJson(JsonInput input) {
            Optional<List<String>> columnNames = Optional.empty();
            Optional<List<Object>> values = Optional.empty();
            Optional<Error> sqlError = Optional.empty();
            input.beginObject();
            block10: while (input.hasNext()) {
                switch (input.nextName()) {
                    case "columnNames": {
                        columnNames = Optional.ofNullable((List)input.read(new TypeToken<List<String>>(){}.getType()));
                        continue block10;
                    }
                    case "values": {
                        values = Optional.ofNullable((List)input.read(new TypeToken<List<Object>>(){}.getType()));
                        continue block10;
                    }
                    case "sqlError": {
                        sqlError = Optional.ofNullable((Error)input.read(Error.class));
                        continue block10;
                    }
                }
                input.skipValue();
            }
            input.endObject();
            return new ExecuteSQLResponse(columnNames, values, sqlError);
        }
    }
}

