package org.openqa.selenium.devtools.v108.debugger.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * JavaScript call frame. Array of call frames form the call stack.
 */
public class CallFrame {

    private final org.openqa.selenium.devtools.v108.debugger.model.CallFrameId callFrameId;

    private final java.lang.String functionName;

    private final java.util.Optional<org.openqa.selenium.devtools.v108.debugger.model.Location> functionLocation;

    private final org.openqa.selenium.devtools.v108.debugger.model.Location location;

    private final java.lang.String url;

    private final java.util.List<org.openqa.selenium.devtools.v108.debugger.model.Scope> scopeChain;

    private final org.openqa.selenium.devtools.v108.runtime.model.RemoteObject _this;

    private final java.util.Optional<org.openqa.selenium.devtools.v108.runtime.model.RemoteObject> returnValue;

    private final java.util.Optional<java.lang.Boolean> canBeRestarted;

    public CallFrame(org.openqa.selenium.devtools.v108.debugger.model.CallFrameId callFrameId, java.lang.String functionName, java.util.Optional<org.openqa.selenium.devtools.v108.debugger.model.Location> functionLocation, org.openqa.selenium.devtools.v108.debugger.model.Location location, java.lang.String url, java.util.List<org.openqa.selenium.devtools.v108.debugger.model.Scope> scopeChain, org.openqa.selenium.devtools.v108.runtime.model.RemoteObject _this, java.util.Optional<org.openqa.selenium.devtools.v108.runtime.model.RemoteObject> returnValue, java.util.Optional<java.lang.Boolean> canBeRestarted) {
        this.callFrameId = java.util.Objects.requireNonNull(callFrameId, "callFrameId is required");
        this.functionName = java.util.Objects.requireNonNull(functionName, "functionName is required");
        this.functionLocation = functionLocation;
        this.location = java.util.Objects.requireNonNull(location, "location is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
        this.scopeChain = java.util.Objects.requireNonNull(scopeChain, "scopeChain is required");
        this._this = java.util.Objects.requireNonNull(_this, "this is required");
        this.returnValue = returnValue;
        this.canBeRestarted = canBeRestarted;
    }

    /**
     * Call frame identifier. This identifier is only valid while the virtual machine is paused.
     */
    public org.openqa.selenium.devtools.v108.debugger.model.CallFrameId getCallFrameId() {
        return callFrameId;
    }

    /**
     * Name of the JavaScript function called on this call frame.
     */
    public java.lang.String getFunctionName() {
        return functionName;
    }

    /**
     * Location in the source code.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v108.debugger.model.Location> getFunctionLocation() {
        return functionLocation;
    }

    /**
     * Location in the source code.
     */
    public org.openqa.selenium.devtools.v108.debugger.model.Location getLocation() {
        return location;
    }

    /**
     * JavaScript script name or url.
     * Deprecated in favor of using the `location.scriptId` to resolve the URL via a previously
     * sent `Debugger.scriptParsed` event.
     */
    @Deprecated()
    public java.lang.String getUrl() {
        return url;
    }

    /**
     * Scope chain for this call frame.
     */
    public java.util.List<org.openqa.selenium.devtools.v108.debugger.model.Scope> getScopeChain() {
        return scopeChain;
    }

    /**
     * `this` object for this call frame.
     */
    public org.openqa.selenium.devtools.v108.runtime.model.RemoteObject getThis() {
        return _this;
    }

    /**
     * The value being returned, if the function is at return point.
     */
    public java.util.Optional<org.openqa.selenium.devtools.v108.runtime.model.RemoteObject> getReturnValue() {
        return returnValue;
    }

    /**
     * Valid only while the VM is paused and indicates whether this frame
     * can be restarted or not. Note that a `true` value here does not
     * guarantee that Debugger#restartFrame with this CallFrameId will be
     * successful, but it is very likely.
     */
    @Beta()
    public java.util.Optional<java.lang.Boolean> getCanBeRestarted() {
        return canBeRestarted;
    }

    private static CallFrame fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v108.debugger.model.CallFrameId callFrameId = null;
        java.lang.String functionName = null;
        java.util.Optional<org.openqa.selenium.devtools.v108.debugger.model.Location> functionLocation = java.util.Optional.empty();
        org.openqa.selenium.devtools.v108.debugger.model.Location location = null;
        java.lang.String url = null;
        java.util.List<org.openqa.selenium.devtools.v108.debugger.model.Scope> scopeChain = null;
        org.openqa.selenium.devtools.v108.runtime.model.RemoteObject _this = null;
        java.util.Optional<org.openqa.selenium.devtools.v108.runtime.model.RemoteObject> returnValue = java.util.Optional.empty();
        java.util.Optional<java.lang.Boolean> canBeRestarted = java.util.Optional.empty();
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "callFrameId":
                    callFrameId = input.read(org.openqa.selenium.devtools.v108.debugger.model.CallFrameId.class);
                    break;
                case "functionName":
                    functionName = input.nextString();
                    break;
                case "functionLocation":
                    functionLocation = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v108.debugger.model.Location.class));
                    break;
                case "location":
                    location = input.read(org.openqa.selenium.devtools.v108.debugger.model.Location.class);
                    break;
                case "url":
                    url = input.nextString();
                    break;
                case "scopeChain":
                    scopeChain = input.read(new com.google.common.reflect.TypeToken<java.util.List<org.openqa.selenium.devtools.v108.debugger.model.Scope>>() {
                    }.getType());
                    break;
                case "this":
                    _this = input.read(org.openqa.selenium.devtools.v108.runtime.model.RemoteObject.class);
                    break;
                case "returnValue":
                    returnValue = java.util.Optional.ofNullable(input.read(org.openqa.selenium.devtools.v108.runtime.model.RemoteObject.class));
                    break;
                case "canBeRestarted":
                    canBeRestarted = java.util.Optional.ofNullable(input.nextBoolean());
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new CallFrame(callFrameId, functionName, functionLocation, location, url, scopeChain, _this, returnValue, canBeRestarted);
    }
}
