/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.internal;

import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriverException;

public class AsyncJavascriptExecutor {
    private final JavascriptExecutor executor;
    private long timeout;
    private TimeUnit timeoutUnit;

    public AsyncJavascriptExecutor(JavascriptExecutor executor, long timeout, TimeUnit timeoutUnit) {
        this.executor = executor;
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public void setTimeout(long timeout, TimeUnit timeoutUnit) {
        this.timeout = timeout;
        this.timeoutUnit = timeoutUnit;
    }

    public Object executeScript(String script, Object ... args) {
        if (!this.executor.isJavascriptEnabled()) {
            throw new IllegalStateException("The underlying JavascriptExecutor must have JavaScript enabled");
        }
        String pageId = UUID.randomUUID().toString();
        String asyncScript = "document.__$webdriverPageId = '" + pageId + "';" + "var timeoutId = window.setTimeout(function() {" + "  window.setTimeout(function() {" + "    document.__$webdriverAsyncTimeout = 1;" + "  }, 0);" + "}, " + this.timeoutUnit.toMillis(this.timeout) + ");" + "document.__$webdriverAsyncTimeout = 0;" + "var callback = function(value) {" + "  document.__$webdriverAsyncTimeout = 0;" + "  document.__$webdriverAsyncScriptResult = value;" + "  window.clearTimeout(timeoutId);" + "};" + "var argsArray = Array.prototype.slice.call(arguments);" + "argsArray.push(callback);" + "delete document.__$webdriverAsyncScriptResult;" + "(function() {" + script + "}).apply(null, argsArray);";
        String pendingId = UUID.randomUUID().toString();
        String pollFunction = "var pendingId = '" + pendingId + "';" + "if (document.__$webdriverPageId != '" + pageId + "') {" + "  return [pendingId, -1];" + "} else if ('__$webdriverAsyncScriptResult' in document) {" + "  var value = document.__$webdriverAsyncScriptResult;" + "  delete document.__$webdriverAsyncScriptResult;" + "  return value;" + "} else {" + "  return [pendingId, document.__$webdriverAsyncTimeout];" + "}";
        long startTimeNanos = System.nanoTime();
        this.executor.executeScript(asyncScript, args);
        while (true) {
            Object result;
            if ((result = this.executor.executeScript(pollFunction, new Object[0])) instanceof List && ((List)result).size() == 2 && pendingId.equals(((List)result).get(0))) {
                long timeoutFlag = ((Number)((List)result).get(1)).longValue();
                if (timeoutFlag < 0L) {
                    throw new WebDriverException("Detected a new page load while waiting for async script result.\nScript: " + script);
                }
                long elapsedTime = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNanos);
                if (timeoutFlag > 0L) {
                    throw new TimeoutException("Timed out waiting for async script callback.\nElapsed time: " + elapsedTime + "ms" + "\nScript: " + script);
                }
            } else {
                return result;
            }
            this.sleep(100L);
        }
    }

    private void sleep(long durationMillis) {
        try {
            Thread.sleep(durationMillis);
        }
        catch (InterruptedException e) {
            throw new WebDriverException(e);
        }
    }
}

