/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.android.library;

import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Message;
import android.view.KeyEvent;
import android.webkit.HttpAuthHandler;
import android.webkit.SslErrorHandler;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import org.openqa.selenium.android.library.AndroidWebDriver;
import org.openqa.selenium.android.library.DriverProvider;
import org.openqa.selenium.android.library.WebDriverViewClient;

class DefaultViewClient
extends WebViewClient
implements DriverProvider {
    private final WebViewClient delegate;
    private WebDriverViewClient wdViewClient;

    public DefaultViewClient() {
        this(null);
    }

    public DefaultViewClient(WebViewClient client) {
        this.delegate = client == null ? new WebViewClient() : client;
    }

    @Override
    public void setDriver(AndroidWebDriver driver) {
        this.wdViewClient = new WebDriverViewClient(driver);
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        this.wdViewClient.onReceivedError(view, errorCode, description, failingUrl);
        this.delegate.onReceivedError(view, errorCode, description, failingUrl);
    }

    public void onFormResubmission(WebView view, Message dontResend, Message resend) {
        this.delegate.onFormResubmission(view, dontResend, resend);
    }

    public void doUpdateVisitedHistory(WebView view, String url, boolean isReload) {
        this.delegate.doUpdateVisitedHistory(view, url, isReload);
    }

    public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
        this.wdViewClient.onReceivedSslError(view, handler, error);
        this.delegate.onReceivedSslError(view, handler, error);
    }

    public void onReceivedHttpAuthRequest(WebView view, HttpAuthHandler handler, String host, String realm) {
        this.delegate.onReceivedHttpAuthRequest(view, handler, host, realm);
    }

    public boolean shouldOverrideKeyEvent(WebView view, KeyEvent event) {
        return this.delegate.shouldOverrideKeyEvent(view, event);
    }

    public void onUnhandledKeyEvent(WebView view, KeyEvent event) {
        this.delegate.onUnhandledKeyEvent(view, event);
    }

    public void onScaleChanged(WebView view, float oldScale, float newScale) {
        this.delegate.onScaleChanged(view, oldScale, newScale);
    }

    public void onReceivedLoginRequest(WebView view, String realm, String account, String args) {
        this.delegate.onReceivedLoginRequest(view, realm, account, args);
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        return this.delegate.shouldOverrideUrlLoading(view, url);
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        this.wdViewClient.onPageStarted(view, url);
        this.delegate.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        this.wdViewClient.onPageFinished(view, url);
        this.delegate.onPageFinished(view, url);
    }

    public void onLoadResource(WebView view, String url) {
        this.delegate.onLoadResource(view, url);
    }

    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        return this.delegate.shouldInterceptRequest(view, url);
    }

    public void onTooManyRedirects(WebView view, Message cancelMsg, Message continueMsg) {
        this.delegate.onTooManyRedirects(view, cancelMsg, continueMsg);
    }
}

