/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.util;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class TunePlayer {
    private final int sampleRate;
    private byte[] buf = new byte[0];
    private int noteLength = 1;
    private int tempo = 60;
    private int octave = 4;

    public TunePlayer() {
        this(16000);
    }

    public TunePlayer(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public int getSampleRate() {
        return this.sampleRate;
    }

    public int getNoteLength() {
        return this.noteLength;
    }

    public int getTempo() {
        return this.tempo;
    }

    public int getOctave() {
        return this.octave;
    }

    public int getTone(int step, char mod) {
        int tone = 12 * (this.getOctave() - 4) + step;
        if (mod == '#' || mod == '+') {
            ++tone;
        }
        if (mod == '-') {
            --tone;
        }
        return tone;
    }

    public int getMillis() {
        return this.toMillis(this.getNoteLength());
    }

    public int toMillis(int noteLen) {
        return 240000 / (noteLen * this.getTempo());
    }

    public void setNoteLength(int noteLength) {
        this.noteLength = noteLength;
    }

    public void setTempo(int tempo) {
        this.tempo = tempo;
    }

    public void setOctave(int octave) {
        this.octave = octave;
    }

    public void downOctave() {
        --this.octave;
    }

    public void upOctave() {
        ++this.octave;
    }

    public SourceDataLine openLine() throws LineUnavailableException {
        AudioFormat af = new AudioFormat(this.sampleRate, 8, 1, true, true);
        SourceDataLine line = AudioSystem.getSourceDataLine(af);
        line.open(af, this.sampleRate);
        line.start();
        return line;
    }

    public void closeLine(SourceDataLine line) {
        line.drain();
        line.close();
    }

    public boolean play(String commandString) {
        String[] tokens;
        SourceDataLine line;
        try {
            line = this.openLine();
        }
        catch (LineUnavailableException e) {
            return false;
        }
        block21: for (String token : tokens = commandString.toUpperCase().split(" ")) {
            char command = token.charAt(0);
            String arg = token.substring(1);
            char mod = token.length() > 1 ? token.charAt(1) : (char)'\u0000';
            switch (command) {
                case '<': {
                    this.downOctave();
                    continue block21;
                }
                case '>': {
                    this.upOctave();
                    continue block21;
                }
                case 'A': {
                    this.play(line, this.getTone(9, mod));
                    continue block21;
                }
                case 'B': {
                    this.play(line, this.getTone(11, mod));
                    continue block21;
                }
                case 'C': {
                    this.play(line, this.getTone(0, mod));
                    continue block21;
                }
                case 'D': {
                    this.play(line, this.getTone(2, mod));
                    continue block21;
                }
                case 'E': {
                    this.play(line, this.getTone(4, mod));
                    continue block21;
                }
                case 'F': {
                    this.play(line, this.getTone(5, mod));
                    continue block21;
                }
                case 'G': {
                    this.play(line, this.getTone(7, mod));
                    continue block21;
                }
                case 'L': {
                    this.setNoteLength(Integer.parseInt(arg));
                    continue block21;
                }
                case 'M': {
                    continue block21;
                }
                case 'N': {
                    int note = Integer.parseInt(arg);
                    if (note == 0) {
                        this.play(line, null);
                        continue block21;
                    }
                    this.play(line, note - 48);
                    continue block21;
                }
                case 'O': {
                    this.setOctave(Integer.parseInt(arg));
                    continue block21;
                }
                case 'P': {
                    int len;
                    try {
                        len = Integer.parseInt(arg);
                    }
                    catch (NumberFormatException exc) {
                        len = this.noteLength;
                    }
                    this.play(line, null, this.toMillis(len));
                    continue block21;
                }
                case 'T': {
                    this.setTempo(Integer.parseInt(arg));
                    continue block21;
                }
                default: {
                    throw new RuntimeException("Unknown command: " + command);
                }
            }
        }
        this.closeLine(line);
        return true;
    }

    private void play(SourceDataLine line, Integer tone) {
        this.play(line, tone, this.getMillis());
    }

    private void play(SourceDataLine line, Integer tone, int ms) {
        int r;
        int length = this.fill(tone, ms);
        for (int count = 0; count < length; count += r) {
            r = line.write(this.buf, count, length - count);
            if (r > 0) continue;
            throw new RuntimeException("Could not write to line");
        }
    }

    private int fill(Integer tone, int ms) {
        int length = this.sampleRate * ms / 1000;
        if (length > this.buf.length) {
            this.buf = new byte[length];
        }
        if (tone == null) {
            Arrays.fill(this.buf, 0, length, (byte)0);
        } else {
            double exp = ((double)tone.intValue() - 1.0) / 12.0;
            double f = 440.0 * Math.pow(2.0, exp);
            for (int i = 0; i < length; ++i) {
                double period = (double)this.sampleRate / f;
                double angle = Math.PI * 2 * (double)i / period;
                this.buf[i] = (byte)(127.0 * Math.sin(angle));
            }
        }
        return length;
    }
}

