/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.tool;

import java.util.List;
import org.scijava.plugin.SingletonService;
import org.scijava.service.SciJavaService;
import org.scijava.tool.Tool;
import org.scijava.util.RealCoords;

public interface ToolService
extends SingletonService<Tool>,
SciJavaService {
    public static final double SEPARATOR_DISTANCE = 10.0;

    public Tool getTool(String var1);

    default public <T extends Tool> T getTool(Class<T> toolClass) {
        for (Tool tool : this.getAlwaysActiveTools()) {
            if (!toolClass.isInstance(tool)) continue;
            return (T)((Tool)toolClass.cast(tool));
        }
        for (Tool tool : this.getTools()) {
            if (!toolClass.isInstance(tool)) continue;
            return (T)((Tool)toolClass.cast(tool));
        }
        return null;
    }

    public List<Tool> getTools();

    public List<Tool> getAlwaysActiveTools();

    public Tool getActiveTool();

    public void setActiveTool(Tool var1);

    default public boolean isSeparatorNeeded(Tool tool1, Tool tool2) {
        double priority2;
        if (tool1 == null || tool2 == null) {
            return false;
        }
        double priority1 = tool1.getInfo().getPriority();
        return Math.abs(priority1 - (priority2 = tool2.getInfo().getPriority())) >= 10.0;
    }

    public void reportRectangle(double var1, double var3, double var5, double var7);

    default public void reportRectangle(RealCoords p1, RealCoords p2) {
        double x = Math.min(p1.x, p2.x);
        double y = Math.min(p1.y, p2.y);
        double w = Math.abs(p2.x - p1.x);
        double h = Math.abs(p2.y - p1.y);
        this.reportRectangle(x, y, w, h);
    }

    public void reportLine(double var1, double var3, double var5, double var7);

    default public void reportLine(RealCoords p1, RealCoords p2) {
        this.reportLine(p1.x, p1.y, p2.x, p2.y);
    }

    public void reportPoint(double var1, double var3);

    default public void reportPoint(RealCoords p) {
        this.reportPoint(p.x, p.y);
    }

    @Override
    default public Class<Tool> getPluginType() {
        return Tool.class;
    }
}

