/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.startup;

import java.util.ArrayDeque;
import java.util.Deque;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;
import org.scijava.startup.StartupService;

@Plugin(type=Service.class)
public class DefaultStartupService
extends AbstractService
implements StartupService {
    private final Deque<Runnable> operations = new ArrayDeque<Runnable>();
    @Parameter(required=false)
    private LogService log;

    @Override
    public void addOperation(Runnable operation) {
        this.operations.add(operation);
    }

    @Override
    public void executeOperations() {
        while (!this.operations.isEmpty()) {
            Runnable operation = this.operations.pop();
            try {
                operation.run();
            }
            catch (RuntimeException exc) {
                if (this.log == null) continue;
                this.log.error(exc);
            }
        }
    }
}

