/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.script;

import java.util.Collections;
import java.util.List;
import javax.script.ScriptEngineFactory;
import org.scijava.plugin.RichPlugin;
import org.scijava.plugin.SingletonPlugin;
import org.scijava.script.AutoCompleter;
import org.scijava.script.DefaultAutoCompleter;
import org.scijava.util.VersionUtils;

public interface ScriptLanguage
extends ScriptEngineFactory,
RichPlugin,
SingletonPlugin {
    default public boolean isCompiledLanguage() {
        return false;
    }

    default public Object decode(Object object) {
        return object;
    }

    default public AutoCompleter getAutoCompleter() {
        return new DefaultAutoCompleter(this);
    }

    @Override
    default public String getMethodCallSyntax(String obj, String m, String ... args) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public String getOutputStatement(String toDisplay) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public String getProgram(String ... statements) {
        throw new UnsupportedOperationException();
    }

    @Override
    default public List<String> getExtensions() {
        return Collections.emptyList();
    }

    @Override
    default public List<String> getNames() {
        return Collections.singletonList(this.getEngineName());
    }

    @Override
    default public String getLanguageVersion() {
        return VersionUtils.getVersion(this.getClass());
    }

    @Override
    default public List<String> getMimeTypes() {
        return Collections.emptyList();
    }

    @Override
    default public Object getParameter(String key) {
        if (key.equals("javax.script.engine")) {
            return this.getEngineName();
        }
        if (key.equals("javax.script.engine_version")) {
            return this.getEngineVersion();
        }
        if (key.equals("javax.script.name")) {
            List<String> list = this.getNames();
            return list.size() > 0 ? list.get(0) : null;
        }
        if (key.equals("javax.script.language")) {
            return this.getLanguageName();
        }
        if (key.equals("javax.script.language_version")) {
            return this.getLanguageVersion();
        }
        return null;
    }

    @Override
    default public String getEngineVersion() {
        return VersionUtils.getVersion(this.getClass());
    }
}

