/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.location;

import org.scijava.io.ByteArrayByteBank;
import org.scijava.io.ByteBank;
import org.scijava.io.location.AbstractLocation;
import org.scijava.util.ByteArray;

public class BytesLocation
extends AbstractLocation {
    private final ByteBank bytes;
    private final String name;

    public BytesLocation(ByteBank bytes) {
        this(bytes, null);
    }

    public BytesLocation(ByteBank bytes, String name) {
        this.bytes = bytes;
        this.name = name;
    }

    public BytesLocation(int initialCapacity) {
        this(initialCapacity, null);
    }

    public BytesLocation(int initialCapacity, String name) {
        this.bytes = new ByteArrayByteBank(initialCapacity);
        this.name = name;
    }

    public BytesLocation(ByteArray bytes) {
        this(bytes, null);
    }

    public BytesLocation(ByteArray bytes, String name) {
        this.bytes = new ByteArrayByteBank(bytes);
        this.name = name;
    }

    public BytesLocation(byte[] bytes) {
        this(bytes, null);
    }

    public BytesLocation(byte[] bytes, String name) {
        this.bytes = new ByteArrayByteBank(bytes);
        this.name = name;
    }

    public BytesLocation(byte[] bytes, int offset, int length) {
        this(bytes, offset, length, null);
    }

    public BytesLocation(byte[] bytes, int offset, int length, String name) {
        this.bytes = new ByteArrayByteBank(length);
        this.bytes.setBytes(0L, bytes, offset, length);
        this.name = name;
    }

    public ByteBank getByteBank() {
        return this.bytes;
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.defaultName();
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }
}

