/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io;

public interface ByteBank {
    public byte getByte(long var1);

    default public int getBytes(long startPos, byte[] bytes) {
        return this.getBytes(startPos, bytes, 0, bytes.length);
    }

    public int getBytes(long var1, byte[] var3, int var4, int var5);

    default public byte[] toByteArray(long offset, int len) {
        if (offset < 0L || len < 0 || offset + (long)len > this.size()) {
            throw new IllegalArgumentException("Invalid range");
        }
        byte[] bytes = new byte[len];
        this.getBytes(offset, bytes);
        return bytes;
    }

    default public byte[] toByteArray() {
        long max = this.size();
        if (max > Integer.MAX_VALUE) {
            throw new IllegalStateException("Byte bank is too large to store into a single byte[]");
        }
        return this.toByteArray(0L, (int)max);
    }

    public void setBytes(long var1, byte[] var3, int var4, int var5);

    default public void appendBytes(byte[] bytes, int length) {
        this.appendBytes(bytes, 0, length);
    }

    default public void appendBytes(byte[] bytes, int offset, int length) {
        this.setBytes(this.size(), bytes, offset, length);
    }

    default public void checkReadPos(long start, long end) {
        this.basicRangeCheck(start, end);
        if (start > this.size()) {
            throw new IndexOutOfBoundsException("Requested position: " + start + " is outside the buffer: " + this.size());
        }
    }

    default public void checkWritePos(long start, long end) {
        if (start > this.size() + 1L) {
            throw new IndexOutOfBoundsException("Requested start position: " + start + " would leave a hole in the buffer, largest legal position is: " + this.size());
        }
        if (end < start) {
            throw new IllegalArgumentException("Invalid range, end is smaller than start!");
        }
        if (end > this.getMaxBufferSize()) {
            throw new IndexOutOfBoundsException("Requested position " + end + " is larger than the maximal buffer size: " + this.getMaxBufferSize());
        }
    }

    default public void basicRangeCheck(long start, long end) {
        if (start > this.size()) {
            throw new IndexOutOfBoundsException("Requested position: " + start + " is outside the buffer: " + this.size());
        }
        if (end < start) {
            throw new IllegalArgumentException("Invalid range, end is smaller than start!");
        }
    }

    public void clear();

    public long size();

    public void setByte(long var1, byte var3);

    public long getMaxBufferSize();

    default public boolean isReadOnly() {
        return false;
    }
}

