/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.app;

import org.scijava.app.AppService;
import org.scijava.app.StatusService;
import org.scijava.app.event.StatusEvent;
import org.scijava.event.EventService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.service.AbstractService;
import org.scijava.service.Service;

@Plugin(type=Service.class)
public class DefaultStatusService
extends AbstractService
implements StatusService {
    @Parameter
    private EventService eventService;
    @Parameter
    private AppService appService;

    @Override
    public void showProgress(int value, int maximum) {
        this.publish(new StatusEvent(value, maximum));
    }

    @Override
    public void showStatus(String message) {
        this.publish(new StatusEvent(message));
    }

    @Override
    public void showStatus(int progress, int maximum, String message) {
        this.publish(new StatusEvent(progress, maximum, message));
    }

    @Override
    public void warn(String message) {
        this.publish(new StatusEvent(message, true));
    }

    @Override
    public void showStatus(int progress, int maximum, String message, boolean warn) {
        this.publish(new StatusEvent(progress, maximum, message, warn));
    }

    @Override
    public void clearStatus() {
        this.publish(new StatusEvent(""));
    }

    @Override
    public String getStatusMessage(String appName, StatusEvent statusEvent) {
        String message = statusEvent.getStatusMessage();
        if (!"".equals(message)) {
            return message;
        }
        return this.appService.getApp(appName).getInfo(false);
    }

    protected void publish(StatusEvent statusEvent) {
        this.eventService.publishLater(statusEvent);
    }
}

