/*
 * Decompiled with CFR 0.152.
 */
package org.scalactic;

import org.scalactic.Equality;
import org.scalactic.Equivalence;
import scala.Predef$;
import scala.math.Numeric;
import scala.runtime.BoxesRunTime;

public interface TolerantNumerics {
    public static Equality tolerantDoubleEquality$(TolerantNumerics $this, double tolerance) {
        return $this.tolerantDoubleEquality(tolerance);
    }

    default public Equality<Object> tolerantDoubleEquality(double tolerance) {
        if (tolerance <= 0.0) {
            throw new IllegalArgumentException(new StringBuilder(91).append(BoxesRunTime.boxToDouble((double)tolerance).toString()).append(" passed to tolerantDoubleEquality was zero or negative. Must be a positive non-zero number.").toString());
        }
        return new Equality<Object>(tolerance){
            private final double tolerance$1;
            {
                this.tolerance$1 = tolerance$8;
            }

            public boolean areEqual(double a, Object b) {
                double bDouble;
                Object object = b;
                return object instanceof Double ? a <= (bDouble = BoxesRunTime.unboxToDouble((Object)object)) + this.tolerance$1 && a >= bDouble - this.tolerance$1 : false;
            }

            public String toString() {
                return new StringBuilder(24).append("TolerantDoubleEquality(").append(this.tolerance$1).append(")").toString();
            }
        };
    }

    public static Equality tolerantFloatEquality$(TolerantNumerics $this, float tolerance) {
        return $this.tolerantFloatEquality(tolerance);
    }

    default public Equality<Object> tolerantFloatEquality(float tolerance) {
        if (tolerance <= 0.0f) {
            throw new IllegalArgumentException(new StringBuilder(90).append(BoxesRunTime.boxToFloat((float)tolerance).toString()).append(" passed to tolerantFloatEquality was zero or negative. Must be a positive non-zero number.").toString());
        }
        return new Equality<Object>(tolerance){
            private final float tolerance$1;
            {
                this.tolerance$1 = tolerance$9;
            }

            public boolean areEqual(float a, Object b) {
                float bFloat;
                Object object = b;
                return object instanceof Float ? a <= (bFloat = BoxesRunTime.unboxToFloat((Object)object)) + this.tolerance$1 && a >= bFloat - this.tolerance$1 : false;
            }

            public String toString() {
                return new StringBuilder(23).append("TolerantFloatEquality(").append(this.tolerance$1).append(")").toString();
            }
        };
    }

    public static Equality tolerantLongEquality$(TolerantNumerics $this, long tolerance) {
        return $this.tolerantLongEquality(tolerance);
    }

    default public Equality<Object> tolerantLongEquality(long tolerance) {
        if (tolerance <= 0L) {
            throw new IllegalArgumentException(new StringBuilder(89).append(BoxesRunTime.boxToLong((long)tolerance).toString()).append(" passed to tolerantLongEquality was zero or negative. Must be a positive non-zero number.").toString());
        }
        return new Equality<Object>(tolerance){
            private final long tolerance$1;
            {
                this.tolerance$1 = tolerance$10;
            }

            public boolean areEqual(long a, Object b) {
                long bLong;
                Object object = b;
                return object instanceof Long ? a <= (bLong = BoxesRunTime.unboxToLong((Object)object)) + this.tolerance$1 && a >= bLong - this.tolerance$1 : false;
            }

            public String toString() {
                return new StringBuilder(22).append("TolerantLongEquality(").append(this.tolerance$1).append(")").toString();
            }
        };
    }

    public static Equality tolerantIntEquality$(TolerantNumerics $this, int tolerance) {
        return $this.tolerantIntEquality(tolerance);
    }

    default public Equality<Object> tolerantIntEquality(int tolerance) {
        if (tolerance <= 0) {
            throw new IllegalArgumentException(new StringBuilder(88).append(BoxesRunTime.boxToInteger((int)tolerance).toString()).append(" passed to tolerantIntEquality was zero or negative. Must be a positive non-zero number.").toString());
        }
        return new Equality<Object>(tolerance){
            private final int tolerance$1;
            {
                this.tolerance$1 = tolerance$11;
            }

            public boolean areEqual(int a, Object b) {
                int bInt;
                Object object = b;
                return object instanceof Integer ? a <= (bInt = BoxesRunTime.unboxToInt((Object)object)) + this.tolerance$1 && a >= bInt - this.tolerance$1 : false;
            }

            public String toString() {
                return new StringBuilder(21).append("TolerantIntEquality(").append(this.tolerance$1).append(")").toString();
            }
        };
    }

    public static Equality tolerantShortEquality$(TolerantNumerics $this, short tolerance) {
        return $this.tolerantShortEquality(tolerance);
    }

    default public Equality<Object> tolerantShortEquality(short tolerance) {
        if (tolerance <= 0) {
            throw new IllegalArgumentException(new StringBuilder(90).append(BoxesRunTime.boxToShort((short)tolerance).toString()).append(" passed to tolerantShortEquality was zero or negative. Must be a positive non-zero number.").toString());
        }
        return new Equality<Object>(tolerance){
            private final short tolerance$1;
            {
                this.tolerance$1 = tolerance$12;
            }

            public boolean areEqual(short a, Object b) {
                short bShort;
                Object object = b;
                return object instanceof Short ? a <= (bShort = BoxesRunTime.unboxToShort((Object)object)) + this.tolerance$1 && a >= bShort - this.tolerance$1 : false;
            }

            public String toString() {
                return new StringBuilder(23).append("TolerantShortEquality(").append(this.tolerance$1).append(")").toString();
            }
        };
    }

    public static Equality tolerantByteEquality$(TolerantNumerics $this, byte tolerance) {
        return $this.tolerantByteEquality(tolerance);
    }

    default public Equality<Object> tolerantByteEquality(byte tolerance) {
        if (tolerance <= 0) {
            throw new IllegalArgumentException(new StringBuilder(89).append(BoxesRunTime.boxToByte((byte)tolerance).toString()).append(" passed to tolerantByteEquality was zero or negative. Must be a positive non-zero number.").toString());
        }
        return new Equality<Object>(tolerance){
            private final byte tolerance$1;
            {
                this.tolerance$1 = tolerance$13;
            }

            public boolean areEqual(byte a, Object b) {
                byte bByte;
                Object object = b;
                return object instanceof Byte ? a <= (bByte = BoxesRunTime.unboxToByte((Object)object)) + this.tolerance$1 && a >= bByte - this.tolerance$1 : false;
            }

            public String toString() {
                return new StringBuilder(22).append("TolerantByteEquality(").append(this.tolerance$1).append(")").toString();
            }
        };
    }

    public static Equivalence tolerantEquivalence$(TolerantNumerics $this, Object tolerance, Numeric evidence$1) {
        return $this.tolerantEquivalence(tolerance, evidence$1);
    }

    default public <N> Equivalence<N> tolerantEquivalence(N tolerance, Numeric<N> evidence$1) {
        Numeric numeric = (Numeric)Predef$.MODULE$.implicitly(evidence$1);
        if (numeric.lt(tolerance, numeric.zero())) {
            throw new IllegalArgumentException(new StringBuilder(88).append(tolerance.toString()).append(" passed to tolerantEquivalence was zero or negative. Must be a positive non-zero number.").toString());
        }
        return new Equivalence<N>(tolerance, numeric){
            private final Object tolerance$1;
            private final Numeric numeric$1;
            {
                this.tolerance$1 = tolerance$14;
                this.numeric$1 = numeric$2;
            }

            public boolean areEquivalent(Object a, Object b) {
                Object bPlusTolerance = this.numeric$1.plus(b, this.tolerance$1);
                Object bMinusTolerance = this.numeric$1.minus(b, this.tolerance$1);
                return this.numeric$1.lteq(a, bPlusTolerance) && this.numeric$1.gteq(a, bMinusTolerance);
            }

            public String toString() {
                return new StringBuilder(21).append("TolerantEquivalence(").append(this.tolerance$1).append(")").toString();
            }
        };
    }
}

