/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.Geometry;
import org.sbml.jsbml.ext.spatial.SpatialModelPlugin;
import org.sbml.jsbml.ext.spatial.SpatialSymbolReference;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class SpatialSymbolReferenceConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1223301, 1223304);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1223301: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1223302: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1223303: {
                func = new UnknownPackageAttributeValidationFunction<SpatialSymbolReference>("spatial"){

                    public boolean check(ValidationContext ctx, SpatialSymbolReference ssr) {
                        if (!ssr.isSetSpatialRef()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)ssr);
                    }
                };
                break;
            }
            case 1223304: {
                func = new ValidationFunction<SpatialSymbolReference>(){

                    public boolean check(ValidationContext ctx, SpatialSymbolReference ssr) {
                        if (ssr.isSetSpatialRef()) {
                            SpatialModelPlugin smp = (SpatialModelPlugin)ssr.getModel().getPlugin("spatial");
                            if (smp.isSetGeometry()) {
                                Geometry g = smp.getGeometry();
                                if (ssr.getSpatialRef().compareTo(g.getId()) == 0) {
                                    return true;
                                }
                            }
                            return false;
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

