/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.ext.spatial.MixedGeometry;
import org.sbml.jsbml.ext.spatial.OrdinalMapping;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class OrdinalMappingConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1223901, 1223905);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1223901: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1223902: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1223903: {
                func = new UnknownPackageAttributeValidationFunction<OrdinalMapping>("spatial"){

                    public boolean check(ValidationContext ctx, OrdinalMapping om) {
                        if (!om.isSetGeometryDefinition()) {
                            return false;
                        }
                        if (!om.isSetOrdinal()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)om);
                    }
                };
                break;
            }
            case 1223904: {
                func = new ValidationFunction<OrdinalMapping>(){

                    public boolean check(ValidationContext ctx, OrdinalMapping om) {
                        if (om.isSetGeometryDefinition()) {
                            MixedGeometry mg = (MixedGeometry)((Object)om.getParent().getParent());
                            ListOf<GeometryDefinition> logd = mg.getListOfGeometryDefinitions();
                            for (GeometryDefinition gd : logd) {
                                if (!gd.getId().equals(om.getGeometryDefinition())) continue;
                                return true;
                            }
                            return false;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223905: {
                func = new InvalidAttributeValidationFunction("ordinal");
            }
        }
        return func;
    }
}

