/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.ext.spatial.MixedGeometry;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class MixedGeometryConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1223801, 1223807);
                set.add(1223850);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1223801: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1223802: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1223803: {
                func = new ValidationFunction<MixedGeometry>(){

                    public boolean check(ValidationContext ctx, MixedGeometry mg) {
                        return new DuplicatedElementValidationFunction("listOfGeometryDefinitions").check(ctx, (TreeNodeWithChangeSupport)mg) && new DuplicatedElementValidationFunction("listOfOrdinalMappings").check(ctx, (TreeNodeWithChangeSupport)mg) && new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)mg);
                    }
                };
                break;
            }
            case 1223804: {
                func = new ValidationFunction<MixedGeometry>(){

                    public boolean check(ValidationContext ctx, MixedGeometry mg) {
                        if (mg.isSetListOfGeometryDefinitions()) {
                            return new UnknownElementValidationFunction().check(ctx, mg.getListOfGeometryDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223805: {
                func = new ValidationFunction<MixedGeometry>(){

                    public boolean check(ValidationContext ctx, MixedGeometry mg) {
                        if (mg.isSetListOfGeometryDefinitions()) {
                            return new UnknownElementValidationFunction().check(ctx, mg.getListOfOrdinalMappings());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223806: {
                func = new ValidationFunction<MixedGeometry>(){

                    public boolean check(ValidationContext ctx, MixedGeometry mg) {
                        if (mg.isSetListOfGeometryDefinitions()) {
                            return new UnknownAttributeValidationFunction().check(ctx, mg.getListOfGeometryDefinitions());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223807: {
                func = new ValidationFunction<MixedGeometry>(){

                    public boolean check(ValidationContext ctx, MixedGeometry mg) {
                        if (mg.isSetListOfGeometryDefinitions()) {
                            return new UnknownAttributeValidationFunction().check(ctx, mg.getListOfOrdinalMappings());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223850: {
                func = new ValidationFunction<MixedGeometry>(){

                    public boolean check(ValidationContext ctx, MixedGeometry mg) {
                        if (mg.isSetListOfGeometryDefinitions()) {
                            ListOf<GeometryDefinition> logd = mg.getListOfGeometryDefinitions();
                            for (GeometryDefinition gd : logd) {
                                if (!gd.getIsActive().booleanValue()) continue;
                                return false;
                            }
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

