/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.GeometryDefinition;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class GeometryDefinitionConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221201, 1221205);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221201: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221202: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221203: {
                func = new UnknownPackageAttributeValidationFunction<GeometryDefinition>("spatial"){

                    public boolean check(ValidationContext ctx, GeometryDefinition gdef) {
                        if (!gdef.isSetId()) {
                            return false;
                        }
                        if (!gdef.isSetIsActive()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)gdef);
                    }
                };
                break;
            }
            case 1221204: {
                func = new InvalidAttributeValidationFunction("isActive");
                break;
            }
            case 1221205: {
                func = new ValidationFunction<GeometryDefinition>(){

                    public boolean check(ValidationContext ctx, GeometryDefinition gdef) {
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

