/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.Model;
import org.sbml.jsbml.ext.spatial.DiffusionCoefficient;
import org.sbml.jsbml.ext.spatial.DiffusionKind;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class DiffusionCoefficientConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1223401, 1223407);
                this.addRangeToSet(set, 1223450, 1223452);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1223401: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1223402: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1223403: {
                func = new UnknownPackageAttributeValidationFunction<DiffusionCoefficient>("spatial"){

                    public boolean check(ValidationContext ctx, DiffusionCoefficient dc) {
                        if (!dc.isSetVariable()) {
                            return false;
                        }
                        if (!dc.isSetType()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)dc);
                    }
                };
                break;
            }
            case 1223404: {
                func = new ValidationFunction<DiffusionCoefficient>(){

                    public boolean check(ValidationContext ctx, DiffusionCoefficient dc) {
                        if (dc.isSetVariable()) {
                            Model m = dc.getModel();
                            return m.getSpecies(dc.getVariable()) != null;
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223405: {
                func = new InvalidAttributeValidationFunction("type");
                break;
            }
            case 1223406: {
                func = new InvalidAttributeValidationFunction("coordinateReference1");
                break;
            }
            case 1223407: {
                func = new InvalidAttributeValidationFunction("coordinateReference2");
                break;
            }
            case 1223450: {
                func = new ValidationFunction<DiffusionCoefficient>(){

                    public boolean check(ValidationContext ctx, DiffusionCoefficient dc) {
                        return !dc.isSetType() || dc.getType() != DiffusionKind.isotropic || !dc.isSetCoordinateReference1() && !dc.isSetCoordinateReference2();
                    }
                };
                break;
            }
            case 1223451: {
                func = new ValidationFunction<DiffusionCoefficient>(){

                    public boolean check(ValidationContext ctx, DiffusionCoefficient dc) {
                        if (dc.isSetType() && dc.getType() == DiffusionKind.tensor) {
                            return dc.isSetCoordinateReference1() && dc.isSetCoordinateReference2();
                        }
                        return true;
                    }
                };
                break;
            }
            case 1223452: {
                func = new ValidationFunction<DiffusionCoefficient>(){

                    public boolean check(ValidationContext ctx, DiffusionCoefficient dc) {
                        if (dc.isSetType() && dc.getType() == DiffusionKind.anisotropic) {
                            return dc.isSetCoordinateReference1() && !dc.isSetCoordinateReference2();
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

