/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.CSGTranslation;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class CSGTranslationConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1222601, 1222606);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1222601: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1222602: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1222603: {
                func = new UnknownPackageAttributeValidationFunction<CSGTranslation>("spatial"){

                    public boolean check(ValidationContext ctx, CSGTranslation csgt) {
                        if (!csgt.isSetTranslateX()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)csgt);
                    }
                };
                break;
            }
            case 1222604: {
                func = new InvalidAttributeValidationFunction("translateX");
                break;
            }
            case 1222605: {
                func = new InvalidAttributeValidationFunction("translateY");
                break;
            }
            case 1222606: {
                func = new InvalidAttributeValidationFunction("translateZ");
            }
        }
        return func;
    }
}

