/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.Set;
import org.sbml.jsbml.ext.spatial.CSGScale;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.InvalidAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;

public class CSGScaleConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1222801, 1222806);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1222801: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1222802: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1222803: {
                func = new UnknownPackageAttributeValidationFunction<CSGScale>("spatial"){

                    public boolean check(ValidationContext ctx, CSGScale csgs) {
                        if (!csgs.isSetScaleX()) {
                            return false;
                        }
                        return super.check(ctx, (TreeNodeWithChangeSupport)csgs);
                    }
                };
                break;
            }
            case 1222804: {
                func = new InvalidAttributeValidationFunction("scaleX");
                break;
            }
            case 1222805: {
                func = new InvalidAttributeValidationFunction("scaleY");
                break;
            }
            case 1222806: {
                func = new InvalidAttributeValidationFunction("scaleZ");
            }
        }
        return func;
    }
}

