/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.validator.offline.constraints;

import java.util.HashSet;
import java.util.Set;
import org.sbml.jsbml.ListOf;
import org.sbml.jsbml.ext.spatial.AnalyticGeometry;
import org.sbml.jsbml.ext.spatial.AnalyticVolume;
import org.sbml.jsbml.util.TreeNodeWithChangeSupport;
import org.sbml.jsbml.validator.SBMLValidator;
import org.sbml.jsbml.validator.offline.ValidationContext;
import org.sbml.jsbml.validator.offline.constraints.AbstractConstraintDeclaration;
import org.sbml.jsbml.validator.offline.constraints.ValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.DuplicatedElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownCoreElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownElementValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageAttributeValidationFunction;
import org.sbml.jsbml.validator.offline.constraints.helper.UnknownPackageElementValidationFunction;

public class AnalyticGeometryConstraints
extends AbstractConstraintDeclaration {
    public void addErrorCodesForAttribute(Set<Integer> set, int level, int version, String attributeName, ValidationContext context) {
    }

    public void addErrorCodesForCheck(Set<Integer> set, int level, int version, SBMLValidator.CHECK_CATEGORY category, ValidationContext context) {
        switch (category) {
            case GENERAL_CONSISTENCY: {
                if (level < 3) break;
                this.addRangeToSet(set, 1221801, 1221805);
                set.add(1221950);
                break;
            }
            case IDENTIFIER_CONSISTENCY: {
                break;
            }
            case MATHML_CONSISTENCY: {
                break;
            }
            case MODELING_PRACTICE: {
                break;
            }
            case OVERDETERMINED_MODEL: {
                break;
            }
            case SBO_CONSISTENCY: {
                break;
            }
        }
    }

    public ValidationFunction<?> getValidationFunction(int errorCode, ValidationContext context) {
        Object func = null;
        switch (errorCode) {
            case 1221801: {
                func = new UnknownCoreAttributeValidationFunction();
                break;
            }
            case 1221802: {
                func = new UnknownCoreElementValidationFunction();
                break;
            }
            case 1221803: {
                func = new ValidationFunction<AnalyticGeometry>(){

                    public boolean check(ValidationContext ctx, AnalyticGeometry ag) {
                        boolean loav = ag.isSetListOfAnalyticVolumes() && new DuplicatedElementValidationFunction("listOfAnalyticVolumes").check(ctx, (TreeNodeWithChangeSupport)ag);
                        boolean noOtherElement = new UnknownPackageElementValidationFunction("spatial").check(ctx, (TreeNodeWithChangeSupport)ag);
                        return loav && noOtherElement;
                    }
                };
                break;
            }
            case 1221804: {
                func = new ValidationFunction<AnalyticGeometry>(){

                    public boolean check(ValidationContext ctx, AnalyticGeometry ag) {
                        if (ag.isSetListOfAnalyticVolumes()) {
                            return new UnknownElementValidationFunction().check(ctx, ag.getListOfAnalyticVolumes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1221805: {
                func = new ValidationFunction<AnalyticGeometry>(){

                    public boolean check(ValidationContext ctx, AnalyticGeometry ag) {
                        if (ag.isSetListOfAnalyticVolumes()) {
                            return new UnknownCoreAttributeValidationFunction().check(ctx, ag.getListOfAnalyticVolumes()) && new UnknownPackageAttributeValidationFunction("spatial").check(ctx, ag.getListOfAnalyticVolumes());
                        }
                        return true;
                    }
                };
                break;
            }
            case 1221950: {
                func = new ValidationFunction<AnalyticGeometry>(){

                    public boolean check(ValidationContext ctx, AnalyticGeometry ag) {
                        if (ag.isSetListOfAnalyticVolumes()) {
                            HashSet<Integer> ordinals = new HashSet<Integer>();
                            ListOf<AnalyticVolume> loav = ag.getListOfAnalyticVolumes();
                            for (AnalyticVolume av : loav) {
                                if (!ordinals.isEmpty() && ordinals.contains(av.getOrdinal())) {
                                    return false;
                                }
                                ordinals.add(av.getOrdinal());
                            }
                        }
                        return true;
                    }
                };
            }
        }
        return func;
    }
}

