/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.CompressionKind;
import org.sbml.jsbml.ext.spatial.DataKind;
import org.sbml.jsbml.ext.spatial.PolygonKind;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;

public class ParametricObject
extends AbstractSpatialNamedSBase {
    private static final transient Logger logger = Logger.getLogger(ParametricObject.class);
    private PolygonKind polygonType;
    private String domainType;
    private CompressionKind compression;
    private String pointIndex;
    private Integer pointIndexLength;
    private DataKind dataType;
    private static final long serialVersionUID = -8093810090391511545L;

    public ParametricObject() {
    }

    public ParametricObject(ParametricObject po) {
        super(po);
        if (po.isSetDomainType()) {
            this.setDomainType(po.getDomainType());
        }
        if (po.isSetPolygonType()) {
            this.setPolygonType(po.getPolygonType());
        }
        if (po.isSetCompression()) {
            this.setCompression(po.getCompression());
        }
        if (po.isSetPointIndex()) {
            this.setPointIndex(po.getPointIndex());
        }
        if (po.isSetPointIndexLength()) {
            this.setPointIndexLength(po.getPointIndexLength());
        }
        if (po.isSetDataType()) {
            this.setDataType(po.getDataType());
        }
    }

    public ParametricObject(int level, int version) {
        super(level, version);
    }

    public ParametricObject(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public ParametricObject clone() {
        return new ParametricObject(this);
    }

    @Override
    public boolean equals(Object object) {
        boolean equal = super.equals(object);
        if (equal) {
            ParametricObject po = (ParametricObject)object;
            if ((equal &= po.isSetDomainType() == this.isSetDomainType()) && this.isSetDomainType()) {
                equal &= po.getDomainType().equals(this.getDomainType());
            }
            if ((equal &= po.isSetPolygonType() == this.isSetPolygonType()) && this.isSetPolygonType()) {
                equal &= po.getPolygonType().equals((Object)this.getPolygonType());
            }
            if ((equal &= po.isSetCompression() == this.isSetCompression()) && this.isSetCompression()) {
                equal &= po.getCompression().equals((Object)this.getCompression());
            }
            if ((equal &= po.isSetPointIndex() == this.isSetPointIndex()) && this.isSetPointIndex()) {
                equal &= po.getPointIndex() == this.getPointIndex();
            }
            if ((equal &= po.isSetPointIndexLength() == this.isSetPointIndexLength()) && this.isSetPointIndexLength()) {
                equal &= po.getPointIndexLength() == this.getPointIndexLength();
            }
            if ((equal &= po.isSetDataType() == this.isSetDataType()) && this.isSetDataType()) {
                equal &= po.getDataType().equals((Object)this.getDataType());
            }
        }
        return equal;
    }

    public PolygonKind getPolygonType() {
        if (this.isSetPolygonType()) {
            return this.polygonType;
        }
        throw new PropertyUndefinedError("polygonType", (SBase)this);
    }

    public boolean isSetPolygonType() {
        return this.polygonType != null;
    }

    public void setPolygonType(String polygonType) {
        this.setPolygonType(PolygonKind.valueOf(polygonType));
    }

    public void setPolygonType(PolygonKind polygonType) {
        PolygonKind oldPolygonType = this.polygonType;
        this.polygonType = polygonType;
        this.firePropertyChange("polygonType", (Object)oldPolygonType, (Object)this.polygonType);
    }

    public boolean unsetPolygonType() {
        if (this.isSetPolygonType()) {
            PolygonKind oldPolygonType = this.polygonType;
            this.polygonType = null;
            this.firePropertyChange("polygonType", (Object)oldPolygonType, (Object)this.polygonType);
            return true;
        }
        return false;
    }

    public String getDomainType() {
        if (this.isSetDomainType()) {
            return this.domainType;
        }
        throw new PropertyUndefinedError("domain", (SBase)this);
    }

    public boolean isSetDomainType() {
        return this.domainType != null;
    }

    public void setDomainType(String domain) {
        String oldDomain = this.domainType;
        this.domainType = domain;
        this.firePropertyChange("domain", oldDomain, this.domainType);
    }

    public boolean unsetDomain() {
        if (this.isSetDomainType()) {
            String oldDomain = this.domainType;
            this.domainType = null;
            this.firePropertyChange("domain", oldDomain, this.domainType);
            return true;
        }
        return false;
    }

    public CompressionKind getCompression() {
        if (this.isSetCompression()) {
            return this.compression;
        }
        throw new PropertyUndefinedError("compression", (SBase)this);
    }

    public boolean isSetCompression() {
        return this.compression != null;
    }

    public void setCompression(String compression) {
        this.setCompression(CompressionKind.valueOf(compression));
    }

    public void setCompression(CompressionKind compression) {
        CompressionKind oldCompression = this.compression;
        this.compression = compression;
        this.firePropertyChange("compression", (Object)oldCompression, (Object)this.compression);
    }

    public boolean unsetCompression() {
        if (this.isSetCompression()) {
            CompressionKind oldCompression = this.compression;
            this.compression = null;
            this.firePropertyChange("compression", (Object)oldCompression, (Object)this.compression);
            return true;
        }
        return false;
    }

    public String getPointIndex() {
        if (this.isSetPointIndex()) {
            return this.pointIndex;
        }
        throw new PropertyUndefinedError("pointIndex", (SBase)this);
    }

    public boolean isSetPointIndex() {
        return this.pointIndex != null;
    }

    public void setPointIndex(String pointIndex) {
        String oldPointIndex = this.pointIndex;
        this.pointIndex = pointIndex;
        this.firePropertyChange("pointIndex", oldPointIndex, this.pointIndex);
    }

    public boolean unsetPointIndex() {
        if (this.isSetPointIndex()) {
            String oldPointIndex = this.pointIndex;
            this.pointIndex = null;
            this.pointIndexLength = null;
            this.firePropertyChange("pointIndex", oldPointIndex, this.pointIndex);
            return true;
        }
        return false;
    }

    public boolean append(String data) {
        if (data == null) {
            return false;
        }
        if (this.isSetPointIndex()) {
            String oldPointIndex = this.pointIndex;
            this.pointIndex = this.pointIndex + data;
            this.firePropertyChange("pointIndex", oldPointIndex, this.pointIndex);
        } else {
            this.setPointIndex(data);
        }
        return true;
    }

    public int getPointIndexLength() {
        if (this.isSetPointIndexLength()) {
            return this.pointIndexLength;
        }
        throw new PropertyUndefinedError("pointIndexLength", (SBase)this);
    }

    public boolean isSetPointIndexLength() {
        return this.pointIndexLength != null;
    }

    public void setPointIndexLength(int pointIndexLength) {
        Integer oldPointIndexLength = this.pointIndexLength;
        this.pointIndexLength = pointIndexLength;
        this.firePropertyChange("pointIndexLength", oldPointIndexLength, this.pointIndexLength);
    }

    public boolean unsetPointIndexLength() {
        if (this.isSetPointIndexLength()) {
            Integer oldPointIndexLength = this.pointIndexLength;
            this.pointIndexLength = null;
            this.firePropertyChange("pointIndexLength", oldPointIndexLength, this.pointIndexLength);
            return true;
        }
        return false;
    }

    public DataKind getDataType() {
        if (this.isSetDataType()) {
            return this.dataType;
        }
        throw new PropertyUndefinedError("dataType", (SBase)this);
    }

    public boolean isSetDataType() {
        return this.dataType != null;
    }

    public void setDataType(String dataType) {
        this.setDataType(DataKind.valueOf(dataType));
    }

    public void setDataType(DataKind dataType) {
        DataKind oldDataType = this.dataType;
        this.dataType = dataType;
        this.firePropertyChange("dataType", (Object)oldDataType, (Object)this.dataType);
    }

    public boolean unsetDataType() {
        if (this.isSetDataType()) {
            DataKind oldDataType = this.dataType;
            this.dataType = null;
            this.firePropertyChange("dataType", (Object)oldDataType, (Object)this.dataType);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 2003;
        int hashCode = super.hashCode();
        if (this.isSetDomainType()) {
            hashCode += 2003 * this.getDomainType().hashCode();
        }
        if (this.isSetPolygonType()) {
            hashCode += 2003 * this.getPolygonType().hashCode();
        }
        if (this.isSetCompression()) {
            hashCode += 2003 * this.getCompression().hashCode();
        }
        if (this.isSetPointIndex()) {
            hashCode += 2003 * this.getPointIndex().hashCode();
        }
        if (this.isSetPointIndexLength()) {
            hashCode += 2003 * this.getPointIndexLength();
        }
        if (this.isSetDataType()) {
            hashCode += 2003 * this.getDataType().hashCode();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetDomainType()) {
            attributes.remove("domainType");
            attributes.put("spatial:domainType", this.getDomainType());
        }
        if (this.isSetPolygonType()) {
            attributes.remove("polygonType");
            attributes.put("spatial:polygonType", this.getPolygonType().toString());
        }
        if (this.isSetCompression()) {
            attributes.remove("compression");
            attributes.put("spatial:compression", this.getCompression().toString());
        }
        if (this.isSetPointIndexLength()) {
            attributes.remove("pointIndexLength");
            attributes.put("spatial:pointIndexLength", String.valueOf(this.getPointIndexLength()));
        }
        if (this.isSetDataType()) {
            attributes.remove("dataType");
            attributes.put("spatial:dataType", this.getDataType().toString().toLowerCase());
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("domainType")) {
                try {
                    this.setDomainType(value);
                }
                catch (Exception e) {
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "domainType", this.getElementName()));
                }
            } else if (attributeName.equals("polygonType")) {
                try {
                    this.setPolygonType(value);
                }
                catch (Exception e) {
                    AbstractReaderWriter.processInvalidAttribute((String)attributeName, null, (String)value, (String)prefix, (Object)this);
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "polygonType", this.getElementName()));
                }
            } else if (attributeName.equals("compression")) {
                try {
                    this.setCompression(value);
                }
                catch (Exception e) {
                    AbstractReaderWriter.processInvalidAttribute((String)attributeName, null, (String)value, (String)prefix, (Object)this);
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "compression", this.getElementName()));
                }
            } else if (attributeName.equals("pointIndexLength")) {
                try {
                    this.setPointIndexLength(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    AbstractReaderWriter.processInvalidAttribute((String)attributeName, null, (String)value, (String)prefix, (Object)this);
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "pointIndexLength", this.getElementName()));
                }
            } else if (attributeName.equals("dataType")) {
                try {
                    this.setDataType(value.toUpperCase());
                }
                catch (Exception e) {
                    AbstractReaderWriter.processInvalidAttribute((String)attributeName, null, (String)value, (String)prefix, (Object)this);
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "dataType", this.getElementName()));
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

