/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import java.util.Map;
import org.apache.log4j.Logger;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBMLException;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.AbstractSpatialNamedSBase;
import org.sbml.jsbml.ext.spatial.SpatialConstants;
import org.sbml.jsbml.util.StringTools;
import org.sbml.jsbml.xml.parsers.AbstractReaderWriter;

public class DomainType
extends AbstractSpatialNamedSBase {
    private static final transient Logger logger = Logger.getLogger(DomainType.class);
    private static final long serialVersionUID = -1429902642364213170L;
    private Integer spatialDimensions;

    public DomainType() {
    }

    public DomainType(DomainType sb) {
        super(sb);
        if (sb.isSetSpatialDimensions()) {
            this.setSpatialDimensions(sb.getSpatialDimensions());
        }
    }

    public DomainType(int level, int version) {
        super(level, version);
    }

    public DomainType(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public DomainType clone() {
        return new DomainType(this);
    }

    @Override
    public boolean equals(Object object) {
        DomainType dt;
        boolean equal = super.equals(object);
        if (equal && (equal &= (dt = (DomainType)object).isSetSpatialDimensions() == this.isSetSpatialDimensions()) && this.isSetSpatialDimensions()) {
            equal &= dt.getSpatialDimensions() == this.getSpatialDimensions();
        }
        return equal;
    }

    public int getSpatialDimensions() {
        if (this.isSetSpatialDimensions()) {
            return this.spatialDimensions;
        }
        throw new PropertyUndefinedError("spatialDimensions", (SBase)this);
    }

    public boolean isSetSpatialDimensions() {
        return this.spatialDimensions != null;
    }

    public void setSpatialDimensions(int spatialDimension) {
        Integer oldSpatialDimension = this.spatialDimensions;
        if (spatialDimension < 0 || spatialDimension > 3) {
            throw new SBMLException("Not a valid spatial dimension. Must be 0, 1, 2, or 3.");
        }
        this.spatialDimensions = spatialDimension;
        this.firePropertyChange("spatialDimensions", oldSpatialDimension, this.spatialDimensions);
    }

    public boolean unsetSpatialDimension() {
        if (this.isSetSpatialDimensions()) {
            int oldSpatialDimension = this.spatialDimensions;
            this.spatialDimensions = null;
            this.firePropertyChange("spatialDimensions", oldSpatialDimension, this.spatialDimensions);
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int prime = 1489;
        int hashCode = super.hashCode();
        if (this.isSetSpatialDimensions()) {
            hashCode += 1489 * this.getSpatialDimensions();
        }
        return hashCode;
    }

    @Override
    public Map<String, String> writeXMLAttributes() {
        Map<String, String> attributes = super.writeXMLAttributes();
        if (this.isSetSpatialDimensions()) {
            attributes.put("spatial:spatialDimensions", String.valueOf(this.getSpatialDimensions()));
        }
        return attributes;
    }

    public boolean readAttribute(String attributeName, String prefix, String value) {
        boolean isAttributeRead = super.readAttribute(attributeName, prefix, value);
        if (!isAttributeRead) {
            isAttributeRead = true;
            if (attributeName.equals("spatialDimensions")) {
                try {
                    this.setSpatialDimensions(StringTools.parseSBMLInt((String)value));
                }
                catch (Exception e) {
                    AbstractReaderWriter.processInvalidAttribute((String)attributeName, null, (String)value, (String)prefix, (Object)this);
                    logger.warn((Object)MessageFormat.format(SpatialConstants.bundle.getString("COULD_NOT_READ_ATTRIBUTE"), value, "spatialDimensions", this.getElementName()));
                    isAttributeRead = false;
                }
            } else {
                isAttributeRead = false;
            }
        }
        return isAttributeRead;
    }
}

