/*
 * Decompiled with CFR 0.152.
 */
package org.sbml.jsbml.ext.spatial;

import java.text.MessageFormat;
import javax.swing.tree.TreeNode;
import org.sbml.jsbml.PropertyUndefinedError;
import org.sbml.jsbml.SBase;
import org.sbml.jsbml.ext.spatial.CSGNode;

public abstract class CSGTransformation
extends CSGNode {
    private static final long serialVersionUID = 5388780141573233538L;
    private CSGNode csgNode;

    public CSGTransformation() {
    }

    public CSGTransformation(CSGTransformation csgt) {
        super(csgt);
        if (csgt.isSetCSGNode()) {
            this.setCSGNode((CSGNode)csgt.getCSGNode().clone());
        }
    }

    public CSGTransformation(int level, int version) {
        super(level, version);
    }

    public CSGTransformation(String id, int level, int version) {
        super(id, level, version);
    }

    @Override
    public boolean equals(Object object) {
        CSGTransformation csgt;
        boolean equal = super.equals(object);
        if (equal && (equal &= (csgt = (CSGTransformation)object).isSetCSGNode() == this.isSetCSGNode()) && this.isSetCSGNode()) {
            equal &= csgt.getCSGNode().equals(this.getCSGNode());
        }
        return equal;
    }

    public CSGNode getCSGNode() {
        if (this.isSetCSGNode()) {
            return this.csgNode;
        }
        throw new PropertyUndefinedError("csgNode", (SBase)this);
    }

    public boolean isSetCSGNode() {
        return this.csgNode != null;
    }

    public void setCSGNode(CSGNode csgNode) {
        CSGNode oldCSGNode = this.csgNode;
        this.csgNode = csgNode;
        this.registerChild(csgNode);
        this.firePropertyChange("csgNode", oldCSGNode, this.csgNode);
    }

    public boolean unsetCSGNode() {
        if (this.isSetCSGNode()) {
            CSGNode oldCSGNode = this.csgNode;
            this.csgNode = null;
            this.firePropertyChange("csgNode", oldCSGNode, this.csgNode);
            return true;
        }
        return false;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public int getChildCount() {
        int count = super.getChildCount();
        if (this.isSetCSGNode()) {
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getChildAt(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexSurpassesBoundsException"), index, 0));
        }
        int count = super.getChildCount();
        int pos = 0;
        if (index < count) {
            return super.getChildAt(index);
        }
        index -= count;
        if (this.isSetCSGNode()) {
            if (pos == index) {
                return this.getCSGNode();
            }
            ++pos;
        }
        throw new IndexOutOfBoundsException(MessageFormat.format(resourceBundle.getString("IndexExceedsBoundsException"), index, Math.min(pos, 0)));
    }
}

