/*
 * Decompiled with CFR 0.152.
 */
package org.robovm.gradle;

import java.util.Collections;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.robovm.compiler.Version;
import org.robovm.gradle.RoboVMPluginExtension;
import org.robovm.gradle.tasks.ActivateLicenseTask;
import org.robovm.gradle.tasks.ArchiveTask;
import org.robovm.gradle.tasks.ConsoleTask;
import org.robovm.gradle.tasks.DeactivateLicenseTask;
import org.robovm.gradle.tasks.IOSDeviceTask;
import org.robovm.gradle.tasks.IPadSimulatorTask;
import org.robovm.gradle.tasks.IPhoneSimulatorTask;
import org.robovm.gradle.tasks.InstallTask;

public class RoboVMPlugin
implements Plugin<Project> {
    public static String getRoboVMVersion() {
        return Version.getVersion();
    }

    public void apply(Project project) {
        project.getExtensions().create("robovm", RoboVMPluginExtension.class, new Object[]{project});
        project.task(Collections.singletonMap("type", IPhoneSimulatorTask.class), "launchIPhoneSimulator");
        project.task(Collections.singletonMap("type", IPadSimulatorTask.class), "launchIPadSimulator");
        project.task(Collections.singletonMap("type", IOSDeviceTask.class), "launchIOSDevice");
        project.task(Collections.singletonMap("type", ConsoleTask.class), "launchConsole");
        project.task(Collections.singletonMap("type", ArchiveTask.class), "createIPA");
        project.task(Collections.singletonMap("type", ArchiveTask.class), "robovmArchive");
        project.task(Collections.singletonMap("type", InstallTask.class), "robovmInstall");
        project.task(Collections.singletonMap("type", ActivateLicenseTask.class), "activateLicense");
        project.task(Collections.singletonMap("type", DeactivateLicenseTask.class), "deactivateLicense");
    }
}

