/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Constructor;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=ParcelFileDescriptor.class)
public class ShadowParcelFileDescriptor {
    private RandomAccessFile file;

    @Implementation
    public static ParcelFileDescriptor open(File file, int mode) throws FileNotFoundException {
        ParcelFileDescriptor pfd;
        try {
            Constructor constructor = ParcelFileDescriptor.class.getDeclaredConstructor(FileDescriptor.class);
            pfd = (ParcelFileDescriptor)constructor.newInstance(new FileDescriptor());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Shadows.shadowOf((ParcelFileDescriptor)pfd).file = new RandomAccessFile(file, mode == 0x10000000 ? "r" : "rw");
        return pfd;
    }

    @Implementation
    public FileDescriptor getFileDescriptor() {
        try {
            return this.file.getFD();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public long getStatSize() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Implementation
    public void close() throws IOException {
        this.file.close();
    }
}

