/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Looper;
import android.widget.OverScroller;
import org.robolectric.Shadows;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.Scheduler;

@Implements(value=OverScroller.class)
public class ShadowOverScroller {
    private int startX;
    private int startY;
    private int finalX;
    private int finalY;
    private long startTime;
    private long duration;
    private boolean started;

    @Implementation
    public int getStartX() {
        return this.startX;
    }

    @Implementation
    public int getStartY() {
        return this.startY;
    }

    @Implementation
    public int getCurrX() {
        long dt = this.deltaTime();
        return dt >= this.duration ? this.finalX : this.startX + (int)((long)this.deltaX() * dt / this.duration);
    }

    @Implementation
    public int getCurrY() {
        long dt = this.deltaTime();
        return dt >= this.duration ? this.finalY : this.startY + (int)((long)this.deltaY() * dt / this.duration);
    }

    @Implementation
    public int getFinalX() {
        return this.finalX;
    }

    @Implementation
    public int getFinalY() {
        return this.finalY;
    }

    @Implementation
    public int getDuration() {
        return (int)this.duration;
    }

    @Implementation
    public void startScroll(int startX, int startY, int dx, int dy, int duration) {
        this.startX = startX;
        this.startY = startY;
        this.finalX = startX + dx;
        this.finalY = startY + dy;
        this.startTime = this.getScheduler().getCurrentTime();
        this.duration = duration;
        this.started = true;
        this.getScheduler().postDelayed(new Runnable(){

            @Override
            public void run() {
            }
        }, (long)duration);
    }

    @Implementation
    public void abortAnimation() {
        this.duration = this.deltaTime() - 1L;
    }

    @Implementation
    public void forceFinished(boolean finished) {
        if (!finished) {
            throw new RuntimeException("Not implemented.");
        }
        this.finalX = this.getCurrX();
        this.finalY = this.getCurrY();
        this.duration = this.deltaTime() - 1L;
    }

    @Implementation
    public boolean computeScrollOffset() {
        if (!this.started) {
            return false;
        }
        this.started &= this.deltaTime() < this.duration;
        return true;
    }

    @Implementation
    public boolean isFinished() {
        return this.deltaTime() > this.duration;
    }

    @Implementation
    public int timePassed() {
        return (int)this.deltaTime();
    }

    @Implementation
    public boolean isScrollingInDirection(float xvel, float yvel) {
        int dx = this.finalX - this.startX;
        int dy = this.finalY - this.startY;
        return !this.isFinished() && Math.signum(xvel) == Math.signum(dx) && Math.signum(yvel) == Math.signum(dy);
    }

    private long deltaTime() {
        return this.getScheduler().getCurrentTime() - this.startTime;
    }

    private Scheduler getScheduler() {
        return Shadows.shadowOf(Looper.getMainLooper()).getScheduler();
    }

    private int deltaX() {
        return this.finalX - this.startX;
    }

    private int deltaY() {
        return this.finalY - this.startY;
    }
}

