/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Notification;
import android.app.NotificationManager;
import android.os.Process;
import android.service.notification.StatusBarNotification;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=NotificationManager.class)
public class ShadowNotificationManager {
    private Map<Key, Notification> notifications = new HashMap<Key, Notification>();

    @Implementation
    public void notify(int id2, Notification notification) {
        this.notify(null, id2, notification);
    }

    @Implementation
    public void notify(String tag, int id2, Notification notification) {
        this.notifications.put(new Key(tag, id2), notification);
    }

    @Implementation
    public void cancel(int id2) {
        this.cancel(null, id2);
    }

    @Implementation
    public void cancel(String tag, int id2) {
        Key key = new Key(tag, id2);
        if (this.notifications.containsKey(key)) {
            this.notifications.remove(key);
        }
    }

    @Implementation
    public void cancelAll() {
        this.notifications.clear();
    }

    @Implementation(minSdk=23)
    public StatusBarNotification[] getActiveNotifications() {
        StatusBarNotification[] statusBarNotifications = new StatusBarNotification[this.notifications.size()];
        int i = 0;
        for (Map.Entry<Key, Notification> entry : this.notifications.entrySet()) {
            statusBarNotifications[i++] = new StatusBarNotification(RuntimeEnvironment.application.getPackageName(), null, entry.getKey().id, entry.getKey().tag, Process.myUid(), Process.myPid(), 0, entry.getValue(), Process.myUserHandle(), 0L);
        }
        return statusBarNotifications;
    }

    public int size() {
        return this.notifications.size();
    }

    public Notification getNotification(int id2) {
        return this.notifications.get(new Key(null, id2));
    }

    public Notification getNotification(String tag, int id2) {
        return this.notifications.get(new Key(tag, id2));
    }

    public List<Notification> getAllNotifications() {
        return new ArrayList<Notification>(this.notifications.values());
    }

    private static final class Key {
        public final String tag;
        public final int id;

        private Key(String tag, int id2) {
            this.tag = tag;
            this.id = id2;
        }

        public int hashCode() {
            int hashCode = 17;
            hashCode = 37 * hashCode + (this.tag == null ? 0 : this.tag.hashCode());
            hashCode = 37 * hashCode + this.id;
            return hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Key)) {
                return false;
            }
            Key other = (Key)o;
            return (this.tag == null ? other.tag == null : this.tag.equals(other.tag)) && this.id == other.id;
        }
    }
}

