/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.Activity;
import android.app.Application;
import android.content.res.Configuration;
import android.os.Looper;
import org.robolectric.Shadows;
import org.robolectric.ShadowsAdapter;
import org.robolectric.manifest.AndroidManifest;
import org.robolectric.shadows.ShadowActivity;
import org.robolectric.shadows.ShadowApplication;
import org.robolectric.shadows.ShadowLog;
import org.robolectric.shadows.ShadowLooper;
import org.robolectric.util.Scheduler;

public class CoreShadowsAdapter
implements ShadowsAdapter {
    public Scheduler getBackgroundScheduler() {
        return ShadowApplication.getInstance().getBackgroundThreadScheduler();
    }

    public ShadowsAdapter.ShadowActivityAdapter getShadowActivityAdapter(Activity component) {
        final ShadowActivity shadow = Shadows.shadowOf(component);
        return new ShadowsAdapter.ShadowActivityAdapter(){

            public void setThemeFromManifest() {
                shadow.setThemeFromManifest();
            }
        };
    }

    public ShadowsAdapter.ShadowLooperAdapter getMainLooper() {
        final ShadowLooper shadow = Shadows.shadowOf(Looper.getMainLooper());
        return new ShadowsAdapter.ShadowLooperAdapter(){

            public void runPaused(Runnable runnable) {
                shadow.runPaused(runnable);
            }
        };
    }

    public String getShadowActivityThreadClassName() {
        return "android.app.ActivityThread";
    }

    public ShadowsAdapter.ShadowApplicationAdapter getApplicationAdapter(Activity component) {
        return new ShadowsAdapter.ShadowApplicationAdapter(){

            public AndroidManifest getAppManifest() {
                return ShadowApplication.getInstance().getAppManifest();
            }
        };
    }

    public void setupLogging() {
        ShadowLog.setupLogging();
    }

    public String getShadowContextImplClassName() {
        return "android.app.ContextImpl";
    }

    public void overrideQualifiers(Configuration configuration, String qualifiers) {
        Shadows.shadowOf(configuration).overrideQualifiers(qualifiers);
    }

    public void bind(Application application, AndroidManifest appManifest) {
        Shadows.shadowOf(application).bind(appManifest);
    }
}

