/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.util.TypedValue;
import org.robolectric.res.AttrData;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResType;
import org.robolectric.res.TypedResource;
import org.robolectric.shadows.ResourceHelper;
import org.robolectric.util.Util;

public class Converter<T> {
    private static int nextStringCookie = 764581;

    static synchronized int getNextStringCookie() {
        return nextStringCookie++;
    }

    static Converter getConverterFor(AttrData attrData, String type) {
        switch (type) {
            case "enum": {
                return new EnumConverter(attrData);
            }
            case "flag": {
                return new FlagConverter(attrData);
            }
            case "boolean": {
                return new FromBoolean();
            }
            case "color": {
                return new FromColor();
            }
            case "dimension": {
                return new FromDimen();
            }
            case "float": {
                return new FromFloat();
            }
            case "integer": {
                return new FromInt();
            }
            case "string": {
                return new FromCharSequence();
            }
            case "fraction": {
                return new FromFraction();
            }
        }
        throw new UnsupportedOperationException("Type not supported: " + type);
    }

    public static Converter getConverter(ResType resType) {
        switch (resType) {
            case ATTR_DATA: {
                return new FromAttrData();
            }
            case BOOLEAN: {
                return new FromBoolean();
            }
            case CHAR_SEQUENCE: {
                return new FromCharSequence();
            }
            case COLOR: 
            case DRAWABLE: {
                return new FromColor();
            }
            case COLOR_STATE_LIST: 
            case LAYOUT: {
                return new FromFilePath();
            }
            case DIMEN: {
                return new FromDimen();
            }
            case FILE: {
                return new FromFile();
            }
            case FLOAT: {
                return new FromFloat();
            }
            case INTEGER: {
                return new FromInt();
            }
            case FRACTION: {
                return new FromFraction();
            }
            case CHAR_SEQUENCE_ARRAY: 
            case INTEGER_ARRAY: {
                return new FromArray();
            }
        }
        throw new UnsupportedOperationException(resType.name());
    }

    public CharSequence asCharSequence(TypedResource typedResource) {
        throw this.cantDo("asCharSequence");
    }

    public int asInt(TypedResource typedResource) {
        throw this.cantDo("asInt");
    }

    public TypedResource[] getItems(TypedResource typedResource) {
        throw this.cantDo("getItems");
    }

    public boolean fillTypedValue(T data, TypedValue typedValue) {
        return false;
    }

    private UnsupportedOperationException cantDo(String operation) {
        return new UnsupportedOperationException(this.getClass().getName() + " doesn't support " + operation);
    }

    private static int convertInt(String rawValue) {
        try {
            return (int)Long.parseLong(rawValue);
        }
        catch (NumberFormatException nfe) {
            return Long.decode(rawValue).intValue();
        }
    }

    private static class EnumOrFlagConverter
    extends Converter<String> {
        private final AttrData attrData;

        public EnumOrFlagConverter(AttrData attrData) {
            this.attrData = attrData;
        }

        protected int findValueFor(String key) {
            String valueFor = this.attrData.getValueFor(key);
            if (valueFor == null) {
                if (this.attrData.isValue(key)) {
                    valueFor = key;
                } else {
                    throw new RuntimeException("no value found for " + key);
                }
            }
            return Util.parseInt((String)valueFor);
        }
    }

    private static class FlagConverter
    extends EnumOrFlagConverter {
        public FlagConverter(AttrData attrData) {
            super(attrData);
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            try {
                int flags = 0;
                for (String key : data.split("\\|")) {
                    flags |= this.findValueFor(key);
                }
                typedValue.type = 17;
                typedValue.data = flags;
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private static class EnumConverter
    extends EnumOrFlagConverter {
        public EnumConverter(AttrData attrData) {
            super(attrData);
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            try {
                typedValue.type = 17;
                typedValue.data = this.findValueFor(data);
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    private static class FromDimen
    extends Converter<String> {
        private FromDimen() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            return ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromBoolean
    extends Converter<String> {
        private FromBoolean() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 18;
            typedValue.assetCookie = 0;
            typedValue.string = null;
            if ("true".equalsIgnoreCase(data)) {
                typedValue.data = 1;
            } else if ("false".equalsIgnoreCase(data)) {
                typedValue.data = 0;
            } else {
                try {
                    int intValue = Integer.parseInt(data);
                    typedValue.data = intValue == 0 ? 0 : 1;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class FromFloat
    extends Converter<String> {
        private FromFloat() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            return ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromFile
    extends Converter<FsFile> {
        private FromFile() {
        }

        @Override
        public boolean fillTypedValue(FsFile data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.string = data.getPath();
            typedValue.assetCookie = FromFile.getNextStringCookie();
            return true;
        }
    }

    private static class FromFraction
    extends Converter<String> {
        private FromFraction() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            return ResourceHelper.parseFloatAttribute(null, data, typedValue, false);
        }
    }

    private static class FromInt
    extends Converter<String> {
        private FromInt() {
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            try {
                typedValue.type = 17;
                typedValue.data = Converter.convertInt(data);
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return Converter.convertInt(typedResource.asString().trim());
        }
    }

    public static class FromArray
    extends Converter {
        @Override
        public TypedResource[] getItems(TypedResource typedResource) {
            return (TypedResource[])typedResource.getData();
        }
    }

    public static class FromFilePath
    extends Converter<String> {
        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.string = data;
            typedValue.assetCookie = FromFilePath.getNextStringCookie();
            return true;
        }
    }

    public static class FromColor
    extends Converter<String> {
        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            try {
                typedValue.type = 28;
                typedValue.data = ResourceHelper.getColor(data);
                typedValue.assetCookie = 0;
                typedValue.string = null;
                return true;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return ResourceHelper.getColor(typedResource.asString().trim());
        }
    }

    public static class FromCharSequence
    extends Converter<String> {
        @Override
        public CharSequence asCharSequence(TypedResource typedResource) {
            return typedResource.asString().trim();
        }

        @Override
        public int asInt(TypedResource typedResource) {
            return Converter.convertInt(typedResource.asString().trim());
        }

        @Override
        public boolean fillTypedValue(String data, TypedValue typedValue) {
            typedValue.type = 3;
            typedValue.data = 0;
            typedValue.assetCookie = FromCharSequence.getNextStringCookie();
            typedValue.string = data;
            return true;
        }
    }

    public static class FromAttrData
    extends Converter<AttrData> {
        @Override
        public CharSequence asCharSequence(TypedResource typedResource) {
            return typedResource.asString();
        }

        @Override
        public boolean fillTypedValue(AttrData data, TypedValue typedValue) {
            typedValue.type = 3;
            return false;
        }
    }
}

