/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import org.robolectric.res.AttributeResource;
import org.robolectric.res.ResBunch;
import org.robolectric.res.ResName;
import org.robolectric.res.ResType;
import org.robolectric.res.StyleData;
import org.robolectric.res.TypedResource;
import org.robolectric.res.XmlLoader;
import org.robolectric.res.XpathResourceXmlLoader;

public class StyleResourceLoader
extends XpathResourceXmlLoader {
    private final ResBunch data;

    public StyleResourceLoader(ResBunch data) {
        super("/resources/style");
        this.data = data;
    }

    @Override
    protected void processNode(String name, XpathResourceXmlLoader.XmlNode xmlNode, XmlLoader.XmlContext xmlContext) {
        int lastDot;
        String styleName = xmlNode.getAttrValue("name");
        String styleParent = xmlNode.getAttrValue("parent");
        if (styleParent == null && (lastDot = styleName.lastIndexOf(46)) != -1) {
            styleParent = styleName.substring(0, lastDot);
        }
        String styleNameWithUnderscores = this.underscorize(styleName);
        StyleData styleData = new StyleData(xmlContext.getPackageName(), styleNameWithUnderscores, this.underscorize(styleParent));
        for (XpathResourceXmlLoader.XmlNode item : xmlNode.selectElements("item")) {
            String attrName = item.getAttrValue("name");
            String value = item.getTextContent();
            ResName attrResName = ResName.qualifyResName(attrName, xmlContext.getPackageName(), "attr");
            styleData.add(attrResName, new AttributeResource(attrResName, value, xmlContext.getPackageName()));
        }
        this.data.put("style", styleNameWithUnderscores, new TypedResource<StyleData>(styleData, ResType.STYLE, xmlContext));
    }

    private String underscorize(String s) {
        return s == null ? null : s.replace('.', '_');
    }
}

