/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.robolectric.res.PackageResourceTable;
import org.robolectric.res.ResourceParser;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.ResourceTable;

public class ResourceTableFactory {
    public static PackageResourceTable newResourceTable(String packageName, ResourcePath ... resourcePaths) {
        PackageResourceTable resourceTable = new PackageResourceTable(packageName);
        for (ResourcePath resourcePath : resourcePaths) {
            if (resourcePath.getRClass() != null) {
                ResourceTableFactory.addRClassValues(resourceTable, resourcePath.getRClass());
            }
            if (resourcePath.getInternalRClass() == null) continue;
            ResourceTableFactory.addRClassValues(resourceTable, resourcePath.getInternalRClass());
        }
        for (ResourcePath resourcePath : resourcePaths) {
            ResourceParser.load(packageName, resourcePath, resourceTable);
        }
        return resourceTable;
    }

    private static void addRClassValues(ResourceTable resourceTable, Class<?> rClass) {
        for (Class<?> innerClass : rClass.getClasses()) {
            for (Field field : innerClass.getDeclaredFields()) {
                int id;
                if (!field.getType().equals(Integer.TYPE) || !Modifier.isStatic(field.getModifiers())) continue;
                String resourceType = innerClass.getSimpleName();
                try {
                    id = field.getInt(null);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
                if (resourceType.equals("styleable")) continue;
                String resourceName = field.getName();
                resourceTable.addResource(id, resourceType, resourceName);
            }
        }
    }
}

