/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.res;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.robolectric.res.Fs;
import org.robolectric.res.FsFile;
import org.robolectric.util.Util;

public class FileFsFile
implements FsFile {
    @VisibleForTesting
    static String FILE_SEPARATOR = File.separator;
    private File canonicalFile;
    private final File file;

    FileFsFile(File file) {
        this.file = file;
    }

    FileFsFile(String path) {
        this.file = new File(path);
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public FsFile[] listFiles() {
        return this.asFsFiles(this.file.listFiles());
    }

    @Override
    public FsFile[] listFiles(final FsFile.Filter filter) {
        return this.asFsFiles(this.file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return filter.accept(new FileFsFile(pathname));
            }
        }));
    }

    @Override
    public String[] listFileNames() {
        File[] files = this.file.listFiles();
        if (files == null) {
            return null;
        }
        String[] strings = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            strings[i] = files[i].getName();
        }
        return strings;
    }

    @Override
    public FsFile getParent() {
        File parentFile = this.file.getParentFile();
        return parentFile == null ? null : Fs.newFile(parentFile);
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    @Override
    public byte[] getBytes() throws IOException {
        return Util.readBytes((InputStream)new FileInputStream(this.file));
    }

    @Override
    public FsFile join(String ... pathParts) {
        File f = this.file;
        for (String pathPart : pathParts) {
            for (String part : pathPart.split(Pattern.quote(FILE_SEPARATOR))) {
                if (part.equals(".")) continue;
                f = new File(f, part);
            }
        }
        return Fs.newFile(f);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public String toString() {
        return this.file.getPath();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileFsFile fsFile = (FileFsFile)o;
        return this.getCanonicalFile().equals(fsFile.getCanonicalFile());
    }

    @Override
    public int hashCode() {
        return this.getCanonicalFile().hashCode();
    }

    @Override
    public String getBaseName() {
        String name = this.getName();
        int dotIndex = name.indexOf(".");
        return dotIndex >= 0 ? name.substring(0, dotIndex) : name;
    }

    @Override
    public String getPath() {
        return this.file.getPath();
    }

    private FsFile[] asFsFiles(File[] files) {
        if (files == null) {
            return null;
        }
        FsFile[] fsFiles = new FsFile[files.length];
        for (int i = 0; i < files.length; ++i) {
            fsFiles[i] = Fs.newFile(files[i]);
        }
        return fsFiles;
    }

    private synchronized File getCanonicalFile() {
        if (this.canonicalFile == null) {
            try {
                this.canonicalFile = this.file.getCanonicalFile();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.canonicalFile;
    }

    @NotNull
    public static FileFsFile from(String ... paths) {
        File file = null;
        for (String path : paths) {
            if (path == null || path.length() <= 0) continue;
            for (String part : path.split(Pattern.quote(FILE_SEPARATOR))) {
                if (file != null && part.equals(".")) continue;
                file = file == null ? new File(part) : new File(file, part);
            }
        }
        return new FileFsFile(file);
    }
}

