/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.manifest;

import android.app.Activity;
import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jetbrains.annotations.Nullable;
import org.robolectric.manifest.ActivityData;
import org.robolectric.manifest.BroadcastReceiverData;
import org.robolectric.manifest.ContentProviderData;
import org.robolectric.manifest.IntentFilterData;
import org.robolectric.manifest.MetaData;
import org.robolectric.manifest.PackageItemData;
import org.robolectric.manifest.PathPermissionData;
import org.robolectric.manifest.ServiceData;
import org.robolectric.res.FsFile;
import org.robolectric.res.ResourcePath;
import org.robolectric.res.ResourceTable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidManifest {
    private final FsFile androidManifestFile;
    private final FsFile resDirectory;
    private final FsFile assetsDirectory;
    private final String overridePackageName;
    private boolean manifestIsParsed;
    private String applicationName;
    private String applicationLabel;
    private String rClassName;
    private String packageName;
    private String processName;
    private String themeRef;
    private String labelRef;
    private Integer minSdkVersion;
    private Integer targetSdkVersion;
    private Integer maxSdkVersion;
    private int versionCode;
    private String versionName;
    private int applicationFlags;
    private final List<ContentProviderData> providers = new ArrayList<ContentProviderData>();
    private final List<BroadcastReceiverData> receivers = new ArrayList<BroadcastReceiverData>();
    private final Map<String, ServiceData> serviceDatas = new LinkedHashMap<String, ServiceData>();
    private final Map<String, ActivityData> activityDatas = new LinkedHashMap<String, ActivityData>();
    private final List<String> usedPermissions = new ArrayList<String>();
    private MetaData applicationMetaData;
    private List<AndroidManifest> libraryManifests = new ArrayList<AndroidManifest>();

    public AndroidManifest(FsFile androidManifestFile, FsFile resDirectory, FsFile assetsDirectory) {
        this(androidManifestFile, resDirectory, assetsDirectory, null);
    }

    public AndroidManifest(FsFile androidManifestFile, FsFile resDirectory, FsFile assetsDirectory, String overridePackageName) {
        this.androidManifestFile = androidManifestFile;
        this.resDirectory = resDirectory;
        this.assetsDirectory = assetsDirectory;
        this.overridePackageName = overridePackageName;
        this.packageName = overridePackageName;
    }

    public String getThemeRef(Class<? extends Activity> activityClass) {
        String themeRef;
        ActivityData activityData = this.getActivityData(activityClass.getName());
        String string = themeRef = activityData != null ? activityData.getThemeRef() : null;
        if (themeRef == null) {
            themeRef = this.getThemeRef();
        }
        return themeRef;
    }

    public String getRClassName() throws Exception {
        this.parseAndroidManifest();
        return this.rClassName;
    }

    public Class getRClass() {
        try {
            String rClassName = this.getRClassName();
            return Class.forName(rClassName);
        }
        catch (Exception e) {
            return null;
        }
    }

    void parseAndroidManifest() {
        if (this.manifestIsParsed) {
            return;
        }
        if (this.androidManifestFile != null && this.androidManifestFile.exists()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                InputStream inputStream = this.androidManifestFile.getInputStream();
                Document manifestDocument = db.parse(inputStream);
                inputStream.close();
                if (!this.packageNameIsOverridden()) {
                    this.packageName = AndroidManifest.getTagAttributeText(manifestDocument, "manifest", "package");
                }
                this.versionCode = this.getTagAttributeIntValue(manifestDocument, "manifest", "android:versionCode", 0);
                this.versionName = AndroidManifest.getTagAttributeText(manifestDocument, "manifest", "android:versionName");
                this.rClassName = this.packageName + ".R";
                this.applicationName = AndroidManifest.getTagAttributeText(manifestDocument, "application", "android:name");
                this.applicationLabel = AndroidManifest.getTagAttributeText(manifestDocument, "application", "android:label");
                this.minSdkVersion = this.getTagAttributeIntValue(manifestDocument, "uses-sdk", "android:minSdkVersion");
                this.targetSdkVersion = this.getTagAttributeIntValue(manifestDocument, "uses-sdk", "android:targetSdkVersion");
                this.maxSdkVersion = this.getTagAttributeIntValue(manifestDocument, "uses-sdk", "android:maxSdkVersion");
                this.processName = AndroidManifest.getTagAttributeText(manifestDocument, "application", "android:process");
                if (this.processName == null) {
                    this.processName = this.packageName;
                }
                this.themeRef = AndroidManifest.getTagAttributeText(manifestDocument, "application", "android:theme");
                this.labelRef = AndroidManifest.getTagAttributeText(manifestDocument, "application", "android:label");
                this.parseApplicationFlags(manifestDocument);
                this.parseReceivers(manifestDocument);
                this.parseServices(manifestDocument);
                this.parseActivities(manifestDocument);
                this.parseApplicationMetaData(manifestDocument);
                this.parseContentProviders(manifestDocument);
                this.parseUsedPermissions(manifestDocument);
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        } else {
            String string = this.rClassName = this.packageName != null && !this.packageName.equals("") ? this.packageName + ".R" : null;
            if (this.androidManifestFile != null) {
                System.err.println("No such manifest file: " + this.androidManifestFile);
            }
        }
        this.manifestIsParsed = true;
    }

    private boolean packageNameIsOverridden() {
        return this.overridePackageName != null && !this.overridePackageName.isEmpty();
    }

    private void parseUsedPermissions(Document manifestDocument) {
        NodeList elementsByTagName = manifestDocument.getElementsByTagName("uses-permission");
        int length = elementsByTagName.getLength();
        for (int i = 0; i < length; ++i) {
            Node node = elementsByTagName.item(i).getAttributes().getNamedItem("android:name");
            this.usedPermissions.add(node.getNodeValue());
        }
    }

    private void parseContentProviders(Document manifestDocument) {
        Node application = manifestDocument.getElementsByTagName("application").item(0);
        if (application == null) {
            return;
        }
        for (Node contentProviderNode : this.getChildrenTags(application, "provider")) {
            String name = this.getAttributeValue(contentProviderNode, "android:name");
            String authority = this.getAttributeValue(contentProviderNode, "android:authorities");
            MetaData metaData = new MetaData(this.getChildrenTags(contentProviderNode, "meta-data"));
            ArrayList<PathPermissionData> pathPermissionDatas = new ArrayList<PathPermissionData>();
            for (Node node : this.getChildrenTags(contentProviderNode, "path-permission")) {
                pathPermissionDatas.add(new PathPermissionData(this.getAttributeValue(node, "android:path"), this.getAttributeValue(node, "android:pathPrefix"), this.getAttributeValue(node, "android:pathPattern"), this.getAttributeValue(node, "android:readPermission"), this.getAttributeValue(node, "android:writePermission")));
            }
            this.providers.add(new ContentProviderData(this.resolveClassRef(name), metaData, authority, this.getAttributeValue(contentProviderNode, "android:readPermission"), this.getAttributeValue(contentProviderNode, "android:writePermission"), pathPermissionDatas));
        }
    }

    @Nullable
    private String getAttributeValue(Node parentNode, String attributeName) {
        Node attributeNode = parentNode.getAttributes().getNamedItem(attributeName);
        return attributeNode == null ? null : attributeNode.getTextContent();
    }

    private void parseReceivers(Document manifestDocument) {
        Node application = manifestDocument.getElementsByTagName("application").item(0);
        if (application == null) {
            return;
        }
        for (Node receiverNode : this.getChildrenTags(application, "receiver")) {
            Node namedItem = receiverNode.getAttributes().getNamedItem("android:name");
            if (namedItem == null) continue;
            String receiverName = this.resolveClassRef(namedItem.getTextContent());
            MetaData metaData = new MetaData(this.getChildrenTags(receiverNode, "meta-data"));
            BroadcastReceiverData receiver = new BroadcastReceiverData(receiverName, metaData);
            List<Node> intentFilters = this.getChildrenTags(receiverNode, "intent-filter");
            for (Node intentFilterNode : intentFilters) {
                for (Node actionNode : this.getChildrenTags(intentFilterNode, "action")) {
                    Node nameNode = actionNode.getAttributes().getNamedItem("android:name");
                    if (nameNode == null) continue;
                    receiver.addAction(nameNode.getTextContent());
                }
            }
            Node permissionItem = receiverNode.getAttributes().getNamedItem("android:permission");
            if (permissionItem != null) {
                receiver.setPermission(permissionItem.getTextContent());
            }
            this.receivers.add(receiver);
        }
    }

    private void parseServices(Document manifestDocument) {
        Node application = manifestDocument.getElementsByTagName("application").item(0);
        if (application == null) {
            return;
        }
        for (Node serviceNode : this.getChildrenTags(application, "service")) {
            Node namedItem = serviceNode.getAttributes().getNamedItem("android:name");
            if (namedItem == null) continue;
            String serviceName = this.resolveClassRef(namedItem.getTextContent());
            MetaData metaData = new MetaData(this.getChildrenTags(serviceNode, "meta-data"));
            ServiceData service = new ServiceData(serviceName, metaData);
            List<Node> intentFilters = this.getChildrenTags(serviceNode, "intent-filter");
            for (Node intentFilterNode : intentFilters) {
                for (Node actionNode : this.getChildrenTags(intentFilterNode, "action")) {
                    Node nameNode = actionNode.getAttributes().getNamedItem("android:name");
                    if (nameNode == null) continue;
                    service.addAction(nameNode.getTextContent());
                }
            }
            Node permissionItem = serviceNode.getAttributes().getNamedItem("android:permission");
            if (permissionItem != null) {
                service.setPermission(permissionItem.getTextContent());
            }
            this.serviceDatas.put(serviceName, service);
        }
    }

    private void parseActivities(Document manifestDocument) {
        Node application = manifestDocument.getElementsByTagName("application").item(0);
        if (application == null) {
            return;
        }
        for (Node activityNode : this.getChildrenTags(application, "activity")) {
            this.parseActivity(activityNode, false);
        }
        for (Node activityNode : this.getChildrenTags(application, "activity-alias")) {
            this.parseActivity(activityNode, true);
        }
    }

    private void parseActivity(Node activityNode, boolean isAlias) {
        NamedNodeMap attributes = activityNode.getAttributes();
        int attrCount = attributes.getLength();
        List<IntentFilterData> intentFilterData = this.parseIntentFilters(activityNode);
        MetaData metaData = new MetaData(this.getChildrenTags(activityNode, "meta-data"));
        HashMap<String, String> activityAttrs = new HashMap<String, String>(attrCount);
        for (int i = 0; i < attrCount; ++i) {
            Node attr = attributes.item(i);
            String v = attr.getNodeValue();
            if (v == null) continue;
            activityAttrs.put(attr.getNodeName(), v);
        }
        String activityName = this.resolveClassRef((String)activityAttrs.get(ActivityData.getNameAttr("android")));
        if (activityName == null) {
            return;
        }
        ActivityData targetActivity = null;
        if (isAlias) {
            String targetName = this.resolveClassRef((String)activityAttrs.get(ActivityData.getTargetAttr("android")));
            if (activityName == null) {
                return;
            }
            targetActivity = this.activityDatas.get(targetName);
            activityAttrs.put(ActivityData.getTargetAttr("android"), targetName);
        }
        activityAttrs.put(ActivityData.getNameAttr("android"), activityName);
        this.activityDatas.put(activityName, new ActivityData("android", activityAttrs, intentFilterData, targetActivity, metaData));
    }

    private List<IntentFilterData> parseIntentFilters(Node activityNode) {
        ArrayList<IntentFilterData> intentFilterDatas = new ArrayList<IntentFilterData>();
        for (Node n : this.getChildrenTags(activityNode, "intent-filter")) {
            NamedNodeMap attributes;
            ArrayList<String> actionNames = new ArrayList<String>();
            ArrayList<String> categories = new ArrayList<String>();
            for (Node action : this.getChildrenTags(n, "action")) {
                attributes = action.getAttributes();
                Node actionNameNode = attributes.getNamedItem("android:name");
                if (actionNameNode == null) continue;
                actionNames.add(actionNameNode.getNodeValue());
            }
            for (Node category : this.getChildrenTags(n, "category")) {
                attributes = category.getAttributes();
                Node categoryNameNode = attributes.getNamedItem("android:name");
                if (categoryNameNode == null) continue;
                categories.add(categoryNameNode.getNodeValue());
            }
            IntentFilterData intentFilterData = new IntentFilterData(actionNames, categories);
            intentFilterData = this.parseIntentFilterData(n, intentFilterData);
            intentFilterDatas.add(intentFilterData);
        }
        return intentFilterDatas;
    }

    private IntentFilterData parseIntentFilterData(Node intentFilterNode, IntentFilterData intentFilterData) {
        for (Node n : this.getChildrenTags(intentFilterNode, "data")) {
            Node mimeTypeNode;
            Node pathPrefixNode;
            Node pathPatternNode;
            Node portNode;
            Node hostNode;
            NamedNodeMap attributes = n.getAttributes();
            String host = null;
            String port = null;
            Node schemeNode = attributes.getNamedItem("android:scheme");
            if (schemeNode != null) {
                intentFilterData.addScheme(schemeNode.getNodeValue());
            }
            if ((hostNode = attributes.getNamedItem("android:host")) != null) {
                host = hostNode.getNodeValue();
            }
            if ((portNode = attributes.getNamedItem("android:port")) != null) {
                port = portNode.getNodeValue();
            }
            intentFilterData.addAuthority(host, port);
            Node pathNode = attributes.getNamedItem("android:path");
            if (pathNode != null) {
                intentFilterData.addPath(pathNode.getNodeValue());
            }
            if ((pathPatternNode = attributes.getNamedItem("android:pathPattern")) != null) {
                intentFilterData.addPathPattern(pathPatternNode.getNodeValue());
            }
            if ((pathPrefixNode = attributes.getNamedItem("android:pathPrefix")) != null) {
                intentFilterData.addPathPrefix(pathPrefixNode.getNodeValue());
            }
            if ((mimeTypeNode = attributes.getNamedItem("android:mimeType")) == null) continue;
            intentFilterData.addMimeType(mimeTypeNode.getNodeValue());
        }
        return intentFilterData;
    }

    public void initMetaData(ResourceTable resourceTable) {
        if (!this.packageNameIsOverridden()) {
            this.parseAndroidManifest();
        }
        if (this.applicationMetaData != null) {
            this.applicationMetaData.init(resourceTable, this.packageName);
        }
        for (PackageItemData packageItemData : this.receivers) {
            packageItemData.getMetaData().init(resourceTable, this.packageName);
        }
        for (ServiceData serviceData : this.serviceDatas.values()) {
            serviceData.getMetaData().init(resourceTable, this.packageName);
        }
    }

    private void parseApplicationMetaData(Document manifestDocument) {
        Node application = manifestDocument.getElementsByTagName("application").item(0);
        if (application == null) {
            return;
        }
        this.applicationMetaData = new MetaData(this.getChildrenTags(application, "meta-data"));
    }

    private String resolveClassRef(String maybePartialClassName) {
        return maybePartialClassName.startsWith(".") ? this.packageName + maybePartialClassName : maybePartialClassName;
    }

    private List<Node> getChildrenTags(Node node, String tagName) {
        ArrayList<Node> children = new ArrayList<Node>();
        for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
            Node childNode = node.getChildNodes().item(i);
            if (!childNode.getNodeName().equalsIgnoreCase(tagName)) continue;
            children.add(childNode);
        }
        return children;
    }

    private void parseApplicationFlags(Document manifestDocument) {
        this.applicationFlags = this.getApplicationFlag(manifestDocument, "android:allowBackup", 32768);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:allowClearUserData", 64);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:allowTaskReparenting", 32);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:debuggable", 2);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:hasCode", 4);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:killAfterRestore", 65536);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:persistent", 8);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:resizeable", 4096);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:restoreAnyVersion", 131072);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:largeScreens", 2048);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:normalScreens", 1024);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:anyDensity", 8192);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:smallScreens", 512);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:testOnly", 256);
        this.applicationFlags += this.getApplicationFlag(manifestDocument, "android:vmSafeMode", 16384);
    }

    private int getApplicationFlag(Document doc, String attribute, int attributeValue) {
        String flagString = AndroidManifest.getTagAttributeText(doc, "application", attribute);
        return "true".equalsIgnoreCase(flagString) ? attributeValue : 0;
    }

    private Integer getTagAttributeIntValue(Document doc, String tag, String attribute) {
        return this.getTagAttributeIntValue(doc, tag, attribute, null);
    }

    private Integer getTagAttributeIntValue(Document doc, String tag, String attribute, Integer defaultValue) {
        String valueString = AndroidManifest.getTagAttributeText(doc, tag, attribute);
        if (valueString != null) {
            return Integer.parseInt(valueString);
        }
        return defaultValue;
    }

    public String getApplicationName() {
        this.parseAndroidManifest();
        return this.applicationName;
    }

    public String getActivityLabel(Class<? extends Activity> activity) {
        this.parseAndroidManifest();
        ActivityData data = this.getActivityData(activity.getName());
        return data != null && data.getLabel() != null ? data.getLabel() : this.applicationLabel;
    }

    @Deprecated
    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        this.parseAndroidManifest();
        return this.packageName;
    }

    public int getVersionCode() {
        return this.versionCode;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getLabelRef() {
        return this.labelRef;
    }

    public int getMinSdkVersion() {
        this.parseAndroidManifest();
        return this.minSdkVersion == null ? 1 : this.minSdkVersion;
    }

    public int getTargetSdkVersion() {
        this.parseAndroidManifest();
        return this.targetSdkVersion == null ? this.getMinSdkVersion() : this.targetSdkVersion.intValue();
    }

    public Integer getMaxSdkVersion() {
        this.parseAndroidManifest();
        return this.maxSdkVersion;
    }

    public int getApplicationFlags() {
        this.parseAndroidManifest();
        return this.applicationFlags;
    }

    public String getProcessName() {
        this.parseAndroidManifest();
        return this.processName;
    }

    public Map<String, Object> getApplicationMetaData() {
        this.parseAndroidManifest();
        if (this.applicationMetaData == null) {
            this.applicationMetaData = new MetaData(Collections.emptyList());
        }
        return this.applicationMetaData.getValueMap();
    }

    public ResourcePath getResourcePath() {
        return new ResourcePath(this.getRClass(), this.resDirectory, this.assetsDirectory);
    }

    public List<ResourcePath> getIncludedResourcePaths() {
        LinkedHashSet<ResourcePath> resourcePaths = new LinkedHashSet<ResourcePath>();
        resourcePaths.add(this.getResourcePath());
        for (AndroidManifest libraryManifest : this.getLibraryManifests()) {
            resourcePaths.addAll(libraryManifest.getIncludedResourcePaths());
        }
        return new ArrayList<ResourcePath>(resourcePaths);
    }

    public List<ContentProviderData> getContentProviders() {
        this.parseAndroidManifest();
        return this.providers;
    }

    public void setLibraryManifests(List<AndroidManifest> libraryManifests) {
        Preconditions.checkNotNull(libraryManifests);
        this.libraryManifests = libraryManifests;
    }

    public List<AndroidManifest> getLibraryManifests() {
        assert (this.libraryManifests != null);
        return Collections.unmodifiableList(this.libraryManifests);
    }

    public FsFile getResDirectory() {
        return this.resDirectory;
    }

    public FsFile getAssetsDirectory() {
        return this.assetsDirectory;
    }

    public FsFile getAndroidManifestFile() {
        return this.androidManifestFile;
    }

    public List<BroadcastReceiverData> getBroadcastReceivers() {
        this.parseAndroidManifest();
        return this.receivers;
    }

    public List<ServiceData> getServices() {
        this.parseAndroidManifest();
        return new ArrayList<ServiceData>(this.serviceDatas.values());
    }

    public ServiceData getServiceData(String serviceClassName) {
        return this.serviceDatas.get(serviceClassName);
    }

    private static String getTagAttributeText(Document doc, String tag, String attribute) {
        NodeList elementsByTagName = doc.getElementsByTagName(tag);
        for (int i = 0; i < elementsByTagName.getLength(); ++i) {
            Node item = elementsByTagName.item(i);
            Node namedItem = item.getAttributes().getNamedItem(attribute);
            if (namedItem == null) continue;
            return namedItem.getTextContent();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AndroidManifest that = (AndroidManifest)o;
        if (this.androidManifestFile != null ? !this.androidManifestFile.equals(that.androidManifestFile) : that.androidManifestFile != null) {
            return false;
        }
        if (this.assetsDirectory != null ? !this.assetsDirectory.equals(that.assetsDirectory) : that.assetsDirectory != null) {
            return false;
        }
        if (this.resDirectory != null ? !this.resDirectory.equals(that.resDirectory) : that.resDirectory != null) {
            return false;
        }
        return !(this.overridePackageName != null ? !this.overridePackageName.equals(that.overridePackageName) : that.overridePackageName != null);
    }

    public int hashCode() {
        int result = this.androidManifestFile != null ? this.androidManifestFile.hashCode() : 0;
        result = 31 * result + (this.resDirectory != null ? this.resDirectory.hashCode() : 0);
        result = 31 * result + (this.assetsDirectory != null ? this.assetsDirectory.hashCode() : 0);
        result = 31 * result + (this.overridePackageName != null ? this.overridePackageName.hashCode() : 0);
        return result;
    }

    public ActivityData getActivityData(String activityClassName) {
        return this.activityDatas.get(activityClassName);
    }

    public String getThemeRef() {
        return this.themeRef;
    }

    public Map<String, ActivityData> getActivityDatas() {
        this.parseAndroidManifest();
        return this.activityDatas;
    }

    public List<String> getUsedPermissions() {
        this.parseAndroidManifest();
        return this.usedPermissions;
    }
}

