/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.java.spi;

import java.lang.ref.WeakReference;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.revapi.CompatibilityType;
import org.revapi.Difference;
import org.revapi.DifferenceSeverity;
import org.revapi.java.spi.JavaAnnotationElement;
import org.revapi.java.spi.JavaElement;
import org.revapi.java.spi.JavaFieldElement;
import org.revapi.java.spi.JavaMethodElement;
import org.revapi.java.spi.JavaMethodParameterElement;
import org.revapi.java.spi.JavaModelElement;
import org.revapi.java.spi.JavaTypeElement;
import org.revapi.java.spi.Util;

public enum Code {
    MISSING_IN_OLD_API("java.missing.oldClass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, new String[0]),
    MISSING_IN_NEW_API("java.missing.newClass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, new String[0]),
    MISSING_OLD_SUPERTYPE("java.missing.oldSuperType", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, "superClass"),
    MISSING_NEW_SUPERTYPE("java.missing.newSuperType", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, "superClass"),
    ELEMENT_NO_LONGER_DEPRECATED("java.element.noLongerDeprecated", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    ELEMENT_NOW_DEPRECATED("java.element.nowDeprecated", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    CLASS_VISIBILITY_INCREASED("java.class.visibilityIncreased", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    CLASS_VISIBILITY_REDUCED("java.class.visibilityReduced", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    CLASS_KIND_CHANGED("java.class.kindChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    CLASS_NO_LONGER_FINAL("java.class.noLongerFinal", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    CLASS_NOW_FINAL("java.class.nowFinal", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    CLASS_NO_LONGER_ABSTRACT("java.class.noLongerAbstract", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    CLASS_NOW_ABSTRACT("java.class.nowAbstract", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    CLASS_ADDED("java.class.added", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    CLASS_REMOVED("java.class.removed", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    CLASS_NO_LONGER_IMPLEMENTS_INTERFACE("java.class.noLongerImplementsInterface", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, "interface"),
    CLASS_NOW_IMPLEMENTS_INTERFACE("java.class.nowImplementsInterface", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, "interface"),
    CLASS_FINAL_CLASS_INHERITS_FROM_NEW_CLASS("java.class.finalClassInheritsFromNewClass", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, "superClass"),
    CLASS_NON_FINAL_CLASS_INHERITS_FROM_NEW_CLASS("java.class.nonFinalClassInheritsFromNewClass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, "superClass"),
    CLASS_NOW_CHECKED_EXCEPTION("java.class.nowCheckedException", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    CLASS_NO_LONGER_INHERITS_FROM_CLASS("java.class.noLongerInheritsFromClass", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    CLASS_NON_PUBLIC_PART_OF_API("java.class.nonPublicPartOfAPI", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, new String[0]),
    CLASS_SUPER_TYPE_TYPE_PARAMETERS_CHANGED("java.class.superTypeTypeParametersChanged", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, "oldSuperType", "newSuperType"),
    CLASS_EXTERNAL_CLASS_EXPOSED_IN_API("java.class.externalClassExposedInAPI", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, new String[0]),
    CLASS_EXTERNAL_CLASS_NO_LONGER_EXPOSED_IN_API("java.class.externalClassNoLongerExposedInAPI", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    CLASS_DEFAULT_SERIALIZATION_CHANGED("java.class.defaultSerializationChanged", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.BREAKING, new String[0]),
    ANNOTATION_ADDED("java.annotation.added", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.POTENTIALLY_BREAKING, "annotation"),
    ANNOTATION_REMOVED("java.annotation.removed", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.POTENTIALLY_BREAKING, "annotation"),
    ANNOTATION_ATTRIBUTE_VALUE_CHANGED("java.annotation.attributeValueChanged", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.POTENTIALLY_BREAKING, "annotationType", "attribute", "oldValue", "newValue"),
    ANNOTATION_ATTRIBUTE_ADDED("java.annotation.attributeAdded", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.POTENTIALLY_BREAKING, "annotation", "attribute"),
    ANNOTATION_ATTRIBUTE_REMOVED("java.annotation.attributeRemoved", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.POTENTIALLY_BREAKING, "annotation", "attribute"),
    ANNOTATION_NO_LONGER_INHERITED("java.annotation.noLongerInherited", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, "annotationType"),
    ANNOTATION_NOW_INHERITED("java.annotation.nowInherited", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, "annotationType"),
    FIELD_ADDED_STATIC_FIELD("java.field.addedStaticField", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    FIELD_ADDED("java.field.added", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    FIELD_REMOVED("java.field.removed", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    FIELD_MOVED_TO_SUPER_CLASS("java.field.movedToSuperClass", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    FIELD_INHERITED_NOW_DECLARED("java.field.inheritedNowDeclared", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    FIELD_CONSTANT_REMOVED("java.field.removedWithConstant", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, new String[0]),
    FIELD_CONSTANT_VALUE_CHANGED("java.field.constantValueChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, new String[0]),
    FIELD_NOW_CONSTANT("java.field.nowConstant", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.POTENTIALLY_BREAKING, new String[0]),
    FIELD_NO_LONGER_CONSTANT("java.field.noLongerConstant", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.BREAKING, new String[0]),
    FIELD_NOW_FINAL("java.field.nowFinal", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, new String[0]),
    FIELD_NO_LONGER_FINAL("java.field.noLongerFinal", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    FIELD_NO_LONGER_STATIC("java.field.noLongerStatic", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    FIELD_NOW_STATIC("java.field.nowStatic", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    FIELD_TYPE_CHANGED("java.field.typeChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    FIELD_SERIAL_VERSION_UID_UNCHANGED("java.field.serialVersionUIDUnchanged", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.POTENTIALLY_BREAKING, "serialVersionUID"),
    FIELD_SERIAL_VERSION_UID_CHANGED("java.field.serialVersionUIDChanged", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, DifferenceSeverity.BREAKING, "oldSerialVersionUID", "newSerialVersionUID"),
    FIELD_VISIBILITY_INCREASED("java.field.visibilityIncreased", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, "oldVisibility", "newVisibility"),
    FIELD_VISIBILITY_REDUCED("java.field.visibilityReduced", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, "oldVisibility", "newVisibility"),
    FIELD_ENUM_CONSTANT_ORDER_CHANGED("java.field.enumConstantOrderChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, new String[0]),
    METHOD_DEFAULT_VALUE_ADDED("java.method.defaultValueAdded", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    METHOD_DEFAULT_VALUE_CHANGED("java.method.defaultValueChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, "oldValue", "newValue"),
    METHOD_DEFAULT_VALUE_REMOVED("java.method.defaultValueRemoved", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, new String[0]),
    METHOD_ADDED_TO_INTERFACE("java.method.addedToInterface", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, new String[0]),
    METHOD_DEFAULT_METHOD_ADDED_TO_INTERFACE("java.method.defaultMethodAddedToInterface", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    METHOD_STATIC_METHOD_ADDED_TO_INTERFACE("java.method.staticMethodAddedToInterface", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    METHOD_ATTRIBUTE_WITH_NO_DEFAULT_ADDED_TO_ANNOTATION_TYPE("java.method.attributeWithNoDefaultAddedToAnnotationType", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, new String[0]),
    METHOD_ATTRIBUTE_WITH_DEFAULT_ADDED_TO_ANNOTATION_TYPE("java.method.attributeWithDefaultAddedToAnnotationType", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    METHOD_ABSTRACT_METHOD_ADDED("java.method.abstractMethodAdded", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_ADDED("java.method.added", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    METHOD_FINAL_METHOD_ADDED_TO_NON_FINAL_CLASS("java.method.finalMethodAddedToNonFinalClass", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, new String[0]),
    METHOD_REMOVED("java.method.removed", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_MOVED_TO_SUPERCLASS("java.method.movedToSuperClass", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    METHOD_INHERITED_METHOD_MOVED_TO_CLASS("java.method.inheritedMovedToClass", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    METHOD_ATTRIBUTE_REMOVED_FROM_ANNOTATION_TYPE("java.method.attributeRemovedFromAnnotationType", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_NO_LONGER_FINAL("java.method.noLongerFinal", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    METHOD_NOW_FINAL("java.method.nowFinal", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, null, new String[0]),
    METHOD_NOW_FINAL_IN_FINAL_CLASS("java.method.nowFinalInFinalClass", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    METHOD_VISIBILITY_INCREASED("java.method.visibilityIncreased", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, "oldVisibility", "newVisibility"),
    METHOD_VISIBILITY_REDUCED("java.method.visibilityReduced", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, "oldVisibility", "newVisibility"),
    METHOD_RETURN_TYPE_CHANGED("java.method.returnTypeChanged", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_RETURN_TYPE_TYPE_PARAMETERS_CHANGED("java.method.returnTypeTypeParametersChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    METHOD_RETURN_TYPE_CHANGED_COVARIANTLY("java.method.returnTypeChangedCovariantly", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_NUMBER_OF_PARAMETERS_CHANGED("java.method.numberOfParametersChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_PARAMETER_TYPE_CHANGED("java.method.parameterTypeChanged", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.BREAKING, null, "parameterIndex"),
    METHOD_PARAMETER_TYPE_PARAMETER_CHANGED("java.method.parameterTypeParameterChanged", DifferenceSeverity.POTENTIALLY_BREAKING, DifferenceSeverity.NON_BREAKING, null, "parameterIndex"),
    METHOD_NO_LONGER_STATIC("java.method.noLongerStatic", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_NOW_STATIC("java.method.nowStatic", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_CHECKED_EXCEPTION_ADDED("java.method.exception.checkedAdded", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null, "exception"),
    METHOD_RUNTIME_EXCEPTION_ADDED("java.method.exception.runtimeAdded", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, "exception"),
    METHOD_CHECKED_EXCEPTION_REMOVED("java.method.exception.checkedRemoved", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null, "exception"),
    METHOD_RUNTIME_EXCEPTION_REMOVED("java.method.exception.runtimeRemoved", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, "exception"),
    METHOD_NO_LONGER_DEFAULT("java.method.noLongerDefault", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_NOW_DEFAULT("java.method.nowDefault", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    METHOD_NOW_ABSTRACT("java.method.nowAbstract", DifferenceSeverity.BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_NO_LONGER_ABSTRACT("java.method.noLongerAbstract", DifferenceSeverity.EQUIVALENT, DifferenceSeverity.EQUIVALENT, null, new String[0]),
    METHOD_PUBLIC_CONSTRUCTOR_OF_ABSTRACT_CLASS_NOW_PROTECTED("java.method.publicConstructorOfAbstractClassNowProtected", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, null, new String[0]),
    GENERICS_ELEMENT_NOW_PARAMETERIZED("java.generics.elementNowParameterized", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.NON_BREAKING, DifferenceSeverity.POTENTIALLY_BREAKING, new String[0]),
    GENERICS_FORMAL_TYPE_PARAMETER_ADDED("java.generics.formalTypeParameterAdded", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null, "typeParameter"),
    GENERICS_FORMAL_TYPE_PARAMETER_REMOVED("java.generics.formalTypeParameterRemoved", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null, "typeParameter"),
    GENERICS_FORMAL_TYPE_PARAMETER_CHANGED("java.generics.formalTypeParameterChanged", DifferenceSeverity.BREAKING, DifferenceSeverity.NON_BREAKING, null, "typeParameter"),
    METHOD_RETURN_TYPE_ERASURE_CHANGED("java.method.returnTypeErasureChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, null, new String[0]),
    METHOD_PARAMETER_TYPE_ERASURE_CHANGED("java.method.parameterTypeErasureChanged", DifferenceSeverity.NON_BREAKING, DifferenceSeverity.BREAKING, null, "parameterIndex");

    private final String code;
    private final EnumMap<CompatibilityType, DifferenceSeverity> classification;
    private final List<String> identifyingAttachments;
    private static WeakHashMap<Locale, WeakReference<Messages>> messagesCache;

    private Code(String code, DifferenceSeverity sourceSeverity, DifferenceSeverity binarySeverity, DifferenceSeverity semanticSeverity, String ... identifyingAttachments) {
        this.code = code;
        this.classification = new EnumMap(CompatibilityType.class);
        this.addClassification(CompatibilityType.SOURCE, sourceSeverity);
        this.addClassification(CompatibilityType.BINARY, binarySeverity);
        this.addClassification(CompatibilityType.SEMANTIC, semanticSeverity);
        this.identifyingAttachments = Collections.unmodifiableList(Arrays.asList(identifyingAttachments));
    }

    public static Code fromCode(String code) {
        for (Code c : Code.values()) {
            if (!c.code.equals(code)) continue;
            return c;
        }
        return null;
    }

    public static <T extends JavaElement> LinkedHashMap<String, String> attachmentsFor(@Nullable T oldElement, @Nullable T newElement, String ... customAttachments) {
        boolean addElementKind;
        T representative;
        T t = representative = oldElement == null ? newElement : oldElement;
        if (representative == null) {
            throw new IllegalArgumentException("At least one of the oldElement and newElement must not be null");
        }
        LinkedHashMap<String, String> ret = Code.keyVals(customAttachments);
        if (representative instanceof JavaAnnotationElement) {
            JavaAnnotationElement anno = (JavaAnnotationElement)representative.as(JavaAnnotationElement.class);
            addElementKind = false;
            ret.put("annotationType", Util.toHumanReadableString(anno.getAnnotation().getAnnotationType()));
            ret.put("elementKind", "annotation");
        } else if (representative instanceof JavaFieldElement) {
            JavaFieldElement field = (JavaFieldElement)representative.as(JavaFieldElement.class);
            addElementKind = true;
            ret.put("package", Code.getPackageName(field));
            ret.put("classQualifiedName", Code.getClassQualifiedName(field));
            ret.put("classSimpleName", Code.getClassSimpleName(field));
            ret.put("fieldName", field.getDeclaringElement().getSimpleName().toString());
        } else if (representative instanceof JavaTypeElement) {
            JavaTypeElement type = (JavaTypeElement)representative.as(JavaTypeElement.class);
            addElementKind = true;
            ret.put("package", Code.getPackageName(type));
            ret.put("classQualifiedName", Code.getClassQualifiedName(type));
            ret.put("classSimpleName", Code.getClassSimpleName(type));
        } else if (representative instanceof JavaMethodElement) {
            JavaMethodElement method = (JavaMethodElement)representative.as(JavaMethodElement.class);
            addElementKind = true;
            ret.put("package", Code.getPackageName(method));
            ret.put("classQualifiedName", Code.getClassQualifiedName(method));
            ret.put("classSimpleName", Code.getClassSimpleName(method));
            ret.put("methodName", method.getDeclaringElement().getSimpleName().toString());
        } else if (representative instanceof JavaMethodParameterElement) {
            JavaMethodParameterElement param = (JavaMethodParameterElement)representative;
            JavaMethodElement method = (JavaMethodElement)((JavaElement)representative.getParent()).as(JavaMethodElement.class);
            addElementKind = true;
            ret.put("package", Code.getPackageName(method));
            ret.put("classQualifiedName", Code.getClassQualifiedName(method));
            ret.put("classSimpleName", Code.getClassSimpleName(method));
            ret.put("methodName", method.getDeclaringElement().getSimpleName().toString());
            ret.put("parameterIndex", Integer.toString(param.getIndex()));
        } else {
            addElementKind = false;
        }
        if (addElementKind) {
            String kind;
            ElementKind elementKind = ((JavaModelElement)representative).getDeclaringElement().getKind();
            switch (elementKind) {
                case ANNOTATION_TYPE: {
                    kind = "@interface";
                    break;
                }
                case CLASS: {
                    kind = "class";
                    break;
                }
                case CONSTRUCTOR: {
                    kind = "constructor";
                    break;
                }
                case ENUM: {
                    kind = "enum";
                    break;
                }
                case ENUM_CONSTANT: {
                    kind = "enumConstant";
                    break;
                }
                case FIELD: {
                    kind = "field";
                    break;
                }
                case INSTANCE_INIT: {
                    kind = "initializer";
                    break;
                }
                case INTERFACE: {
                    kind = "interface";
                    break;
                }
                case METHOD: {
                    kind = "method";
                    break;
                }
                case PACKAGE: {
                    kind = "package";
                    break;
                }
                case PARAMETER: {
                    kind = "parameter";
                    break;
                }
                case STATIC_INIT: {
                    kind = "staticInitializer";
                    break;
                }
                case TYPE_PARAMETER: {
                    kind = "typeParameter";
                    break;
                }
                default: {
                    kind = "unknownKind(" + (Object)((Object)elementKind) + ")";
                }
            }
            ret.put("elementKind", kind);
        }
        return ret;
    }

    private static String getPackageName(JavaModelElement element) {
        Element pkg;
        while (element != null && !(element instanceof JavaTypeElement)) {
            element = element.getParent();
        }
        if (element == null) {
            return "";
        }
        TypeElement type = ((JavaTypeElement)element.as(JavaTypeElement.class)).getDeclaringElement();
        for (pkg = type.getEnclosingElement(); pkg != null && pkg.getKind() != ElementKind.PACKAGE; pkg = pkg.getEnclosingElement()) {
        }
        if (pkg == null) {
            return "";
        }
        return ((PackageElement)pkg).getQualifiedName().toString();
    }

    private static String getClassSimpleName(JavaModelElement element) {
        TypeElement declaringClass = Code.getDeclaringClass(element);
        return declaringClass == null ? null : declaringClass.getSimpleName().toString();
    }

    private static String getClassQualifiedName(JavaModelElement element) {
        TypeElement declaringClass = Code.getDeclaringClass(element);
        return declaringClass == null ? null : declaringClass.getQualifiedName().toString();
    }

    private static TypeElement getDeclaringClass(JavaModelElement element) {
        while (element != null && !(element instanceof JavaTypeElement)) {
            element = element.getParent();
        }
        return element == null ? null : ((JavaTypeElement)element.as(JavaTypeElement.class)).getDeclaringElement();
    }

    public String code() {
        return this.code;
    }

    public Difference createDifference(@Nonnull Locale locale) {
        Message message = Code.getMessages(locale).get(this.code);
        Difference.Builder bld = (Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)Difference.builder().withCode(this.code)).withName(message.name)).withDescription(message.description)).withDocumentationLink(Code.toDocLink(this.code));
        for (Map.Entry<CompatibilityType, DifferenceSeverity> e : this.classification.entrySet()) {
            bld.addClassification(e.getKey(), e.getValue());
        }
        return bld.build();
    }

    public Difference createDifference(@Nonnull Locale locale, LinkedHashMap<String, String> attachments) {
        String[] params = attachments.values().toArray(new String[attachments.size()]);
        return this.createDifference(locale, attachments, params);
    }

    public Difference createDifference(@Nonnull Locale locale, LinkedHashMap<String, String> attachments, String ... parameters) {
        Message message = Code.getMessages(locale).get(this.code);
        String description = MessageFormat.format(message.description, parameters);
        Difference.Builder bld = (Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)((Difference.Builder)Difference.builder().withCode(this.code)).withName(message.name)).withDescription(description)).withDocumentationLink(Code.toDocLink(this.code))).addAttachments(attachments)).withIdentifyingAttachments(this.identifyingAttachments);
        for (Map.Entry<CompatibilityType, DifferenceSeverity> e : this.classification.entrySet()) {
            bld.addClassification(e.getKey(), e.getValue());
        }
        return bld.build();
    }

    private static URI toDocLink(String code) {
        return URI.create("https://revapi.org/revapi-java/differences.html#" + code);
    }

    private static LinkedHashMap<String, String> keyVals(String ... keyVals) {
        if (keyVals.length % 2 != 0) {
            throw new IllegalArgumentException("Uneven key-value pairs.");
        }
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>(keyVals.length / 2);
        String currentKey = null;
        for (int i = 0; i < keyVals.length; ++i) {
            String x = keyVals[i];
            if (x == null) {
                throw new IllegalArgumentException("Null keys or values not supported in attachments.");
            }
            if (i % 2 == 0) {
                currentKey = keyVals[i];
                continue;
            }
            ret.put(currentKey, x);
        }
        return ret;
    }

    private static synchronized Messages getMessages(Locale locale) {
        WeakReference<Messages> messageRef = messagesCache.get(locale);
        if (messageRef == null || messageRef.get() == null) {
            messageRef = new WeakReference<Messages>(new Messages(locale));
            messagesCache.put(locale, messageRef);
        }
        return (Messages)messageRef.get();
    }

    private void addClassification(CompatibilityType compatibilityType, DifferenceSeverity severity) {
        if (severity != null) {
            this.classification.put(compatibilityType, severity);
        }
    }

    static {
        messagesCache = new WeakHashMap();
    }

    private static class Messages {
        private final ResourceBundle names;
        private final ResourceBundle descriptions;

        public Messages(Locale locale) {
            this.descriptions = ResourceBundle.getBundle("org.revapi.java.checks.descriptions", locale);
            this.names = ResourceBundle.getBundle("org.revapi.java.checks.names", locale);
        }

        Message get(String key) {
            String name = this.names.getString(key);
            String description = this.descriptions.getString(key);
            return new Message(name, description);
        }
    }

    private static class Message {
        final String name;
        final String description;

        private Message(String name, String description) {
            this.description = description;
            this.name = name;
        }
    }
}

