/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.util.ArrayList;
import java.util.List;
import org.restlet.data.CharacterSet;
import org.restlet.data.Encoding;
import org.restlet.data.Language;
import org.restlet.data.MediaType;
import org.restlet.data.Preference;
import org.restlet.resource.Resource;
import org.restlet.resource.Variant;
import org.restlet.util.Engine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClientInfo {
    private List<String> addresses = null;
    private String agent = null;
    private int port = -1;
    private List<Preference<CharacterSet>> characterSetPrefs = null;
    private List<Preference<Encoding>> encodingPrefs = null;
    private List<Preference<Language>> languagePrefs = null;
    private List<Preference<MediaType>> mediaTypePrefs = null;

    public List<Preference<CharacterSet>> getAcceptedCharacterSets() {
        if (this.characterSetPrefs == null) {
            this.characterSetPrefs = new ArrayList<Preference<CharacterSet>>();
        }
        return this.characterSetPrefs;
    }

    public List<Preference<Encoding>> getAcceptedEncodings() {
        if (this.encodingPrefs == null) {
            this.encodingPrefs = new ArrayList<Preference<Encoding>>();
        }
        return this.encodingPrefs;
    }

    public List<Preference<Language>> getAcceptedLanguages() {
        if (this.languagePrefs == null) {
            this.languagePrefs = new ArrayList<Preference<Language>>();
        }
        return this.languagePrefs;
    }

    public List<Preference<MediaType>> getAcceptedMediaTypes() {
        if (this.mediaTypePrefs == null) {
            this.mediaTypePrefs = new ArrayList<Preference<MediaType>>();
        }
        return this.mediaTypePrefs;
    }

    public String getAddress() {
        return this.addresses == null ? null : (this.addresses.isEmpty() ? null : this.addresses.get(0));
    }

    public List<String> getAddresses() {
        if (this.addresses == null) {
            this.addresses = new ArrayList<String>();
        }
        return this.addresses;
    }

    public String getAgent() {
        return this.agent;
    }

    public int getPort() {
        return this.port;
    }

    public Variant getPreferredVariant(List<Variant> variants, Language defaultLanguage) {
        return Engine.getInstance().getPreferredVariant(this, variants, defaultLanguage);
    }

    public Variant getPreferredVariant(Resource resource, Language defaultLanguage) {
        return this.getPreferredVariant(resource.getVariants(), defaultLanguage);
    }

    public void setAddress(String address) {
        if (this.getAddresses().isEmpty()) {
            this.getAddresses().add(address);
        } else {
            this.getAddresses().set(0, address);
        }
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

