/*
 * Decompiled with CFR 0.152.
 */
package org.restlet;

import java.lang.reflect.Constructor;
import java.util.Set;
import java.util.logging.Level;
import org.restlet.Context;
import org.restlet.Restlet;
import org.restlet.data.Method;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Finder
extends Restlet {
    private Class<? extends Resource> targetClass;

    public Finder() {
        this(null);
    }

    public Finder(Context context) {
        this(context, null);
    }

    public Finder(Context context, Class<? extends Resource> targetClass) {
        super(context);
        this.targetClass = targetClass;
    }

    private boolean allowMethod(Method method, Resource target) {
        boolean result = false;
        if (target != null) {
            if (method.equals(Method.GET) || method.equals(Method.HEAD)) {
                result = target.allowGet();
            } else if (method.equals(Method.POST)) {
                result = target.allowPost();
            } else if (method.equals(Method.PUT)) {
                result = target.allowPut();
            } else if (method.equals(Method.DELETE)) {
                result = target.allowDelete();
            } else if (method.equals(Method.OPTIONS)) {
                result = true;
            } else {
                java.lang.reflect.Method allowMethod = this.getAllowMethod(method, target);
                if (allowMethod != null) {
                    result = (Boolean)this.invoke(target, allowMethod, new Object[0]);
                }
            }
        }
        return result;
    }

    public Resource findTarget(Request request, Response response) {
        return this.createResource(request, response);
    }

    public Resource createResource(Request request, Response response) {
        Resource result = null;
        if (this.getTargetClass() != null) {
            try {
                try {
                    Constructor<? extends Resource> constructor = this.getTargetClass().getConstructor(Context.class, Request.class, Response.class);
                    result = constructor.newInstance(this.getContext(), request, response);
                }
                catch (NoSuchMethodException nsme) {
                    Constructor<? extends Resource> constructor = this.getTargetClass().getConstructor(new Class[0]);
                    if (constructor != null) {
                        result = constructor.newInstance(new Object[0]);
                        result.init(this.getContext(), request, response);
                    }
                }
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Exception while instantiating the target resource.", e);
            }
        }
        return result;
    }

    private java.lang.reflect.Method getAllowMethod(Method method, Resource target) {
        return this.getMethod("allow", method, target, new Class[0]);
    }

    private java.lang.reflect.Method getHandleMethod(Resource target, Method method) {
        return this.getMethod("handle", method, target, new Class[0]);
    }

    private java.lang.reflect.Method getMethod(String prefix, Method method, Object target, Class<?> ... classes) {
        java.lang.reflect.Method result = null;
        StringBuilder sb = new StringBuilder();
        String methodName = method.getName().toLowerCase();
        if (methodName != null && methodName.length() > 0) {
            sb.append(prefix);
            sb.append(Character.toUpperCase(methodName.charAt(0)));
            sb.append(methodName.substring(1));
        }
        try {
            result = target.getClass().getMethod(sb.toString(), classes);
        }
        catch (SecurityException e) {
            this.getLogger().log(Level.WARNING, "Couldn't access the " + prefix + " method for \"" + method + "\"", e);
        }
        catch (NoSuchMethodException e) {
            this.getLogger().log(Level.INFO, "Couldn't find the " + prefix + " method for \"" + method + "\"", e);
        }
        return result;
    }

    public Class<? extends Resource> getTargetClass() {
        return this.targetClass;
    }

    @Override
    public void handle(Request request, Response response) {
        this.init(request, response);
        if (this.isStarted()) {
            Resource target = this.findTarget(request, response);
            if (response.getStatus().equals(Status.SUCCESS_OK)) {
                if (target == null) {
                    response.setStatus(Status.CLIENT_ERROR_NOT_FOUND);
                } else {
                    Method method = request.getMethod();
                    if (method == null) {
                        response.setStatus(Status.CLIENT_ERROR_BAD_REQUEST, "No method specified");
                    } else if (!this.allowMethod(method, target)) {
                        response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                        this.updateAllowedMethods(response, target);
                    } else if (method.equals(Method.GET)) {
                        target.handleGet();
                    } else if (method.equals(Method.HEAD)) {
                        target.handleHead();
                    } else if (method.equals(Method.POST)) {
                        target.handlePost();
                    } else if (method.equals(Method.PUT)) {
                        target.handlePut();
                    } else if (method.equals(Method.DELETE)) {
                        target.handleDelete();
                    } else if (method.equals(Method.OPTIONS)) {
                        target.handleOptions();
                    } else {
                        java.lang.reflect.Method handleMethod = this.getHandleMethod(target, method);
                        if (handleMethod != null) {
                            this.invoke(target, handleMethod, new Object[0]);
                        } else {
                            response.setStatus(Status.CLIENT_ERROR_METHOD_NOT_ALLOWED);
                        }
                    }
                }
            }
        }
    }

    private Object invoke(Object target, java.lang.reflect.Method method, Object ... args) {
        Object result = null;
        if (method != null) {
            try {
                result = method.invoke(target, args);
            }
            catch (Exception e) {
                this.getLogger().log(Level.WARNING, "Couldn't invoke the handle method for \"" + method + "\"", e);
            }
        }
        return result;
    }

    private void updateAllowedMethods(Response response, Resource target) {
        Set<Method> allowedMethods = response.getAllowedMethods();
        for (java.lang.reflect.Method classMethod : target.getClass().getMethods()) {
            if (!classMethod.getName().startsWith("allow") || classMethod.getParameterTypes().length != 0 || !((Boolean)this.invoke(target, classMethod, new Object[0])).booleanValue()) continue;
            Method allowedMethod = Method.valueOf(classMethod.getName().substring(5));
            allowedMethods.add(allowedMethod);
        }
    }
}

