// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.net.impls;

import static org.junit.Assert.assertEquals;

import org.junit.Test;
import org.refcodes.data.Delimiter;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.HeaderField;
import org.refcodes.net.RequestCookie;
import org.refcodes.net.RequestHeaderFields;
import org.refcodes.net.impls.RequestHeaderFieldsImpl;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;

public class RequestHeaderFieldsTest {

	private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testHeaderFieldCookie() {
		RequestHeaderFields theHeaderFields = new RequestHeaderFieldsImpl();
		String theKey = "REFCODES";
		String theValue = "5161";
		theHeaderFields.addTo( HeaderField.COOKIE.getName() , theKey + Delimiter.COOKIE_TUPEL_DELIMITER.getChar() + theValue );
		assertEquals( theHeaderFields.getAllCookies().size(), 1 );
		RequestCookie theCookie = theHeaderFields.getAllCookies().get( 0 );

		LOGGER.info( new VerboseTextBuilderImpl().withElements( theHeaderFields.toHttpCookies() ).toString() );
		assertEquals( theKey,  theCookie.getKey() );
		assertEquals( theValue,  theCookie.getValue() );
	}
	
	@Test
	public void testHeaderFieldCookies() {
		RequestHeaderFields theHeaderFields = new RequestHeaderFieldsImpl();
		String theKey = "REFCODES";
		String theValue = "5161";
		theHeaderFields.addTo( HeaderField.COOKIE.getName() , theKey + Delimiter.COOKIE_TUPEL_DELIMITER.getChar() + theValue );
		assertEquals( theHeaderFields.getAllCookies().size(), 1 );
		RequestCookie theCookie = theHeaderFields.getAllCookies().get( 0 );
		
		LOGGER.info( new VerboseTextBuilderImpl().withElements( theHeaderFields.toHttpCookies() ).toString() );
		assertEquals( theKey,  theCookie.getKey() );
		assertEquals( theValue,  theCookie.getValue() );
		
		theKey = "COMCODES";
		theValue = "5162";
		theHeaderFields.addTo( HeaderField.COOKIE.getName() , theKey + Delimiter.COOKIE_TUPEL_DELIMITER.getChar() + theValue );
		assertEquals( theHeaderFields.getAllCookies().size(), 2 );
		theCookie = theHeaderFields.getAllCookies().get( 1 );
		
		LOGGER.info( new VerboseTextBuilderImpl().withElements( theHeaderFields.toHttpCookies() ).toString() );
		assertEquals( theKey,  theCookie.getKey() );
		assertEquals( theValue,  theCookie.getValue() );
	}
	
	@Test
	public void testMixedCookies() {
		RequestHeaderFields theHeaderFields = new RequestHeaderFieldsImpl();
		String theKey = "REFCODES";
		String theValue = "5161";
		theHeaderFields.addTo( HeaderField.COOKIE.getName() , theKey + Delimiter.COOKIE_TUPEL_DELIMITER.getChar() + theValue );
		assertEquals( theHeaderFields.getAllCookies().size(), 1 );
		RequestCookie theCookie = theHeaderFields.getAllCookies().get( 0 );
		
		LOGGER.info( new VerboseTextBuilderImpl().withElements( theHeaderFields.toHttpCookies() ).toString() );
		assertEquals( theKey,  theCookie.getKey() );
		assertEquals( theValue,  theCookie.getValue() );
		
		theKey = "COMCODES";
		theValue = "5162";
		theHeaderFields.addTo( HeaderField.COOKIE.getName() , theKey + Delimiter.COOKIE_TUPEL_DELIMITER.getChar() + theValue );
		assertEquals( theHeaderFields.getAllCookies().size(), 2 );
		theCookie = theHeaderFields.getAllCookies().get( 1 );
		
		LOGGER.info( new VerboseTextBuilderImpl().withElements( theHeaderFields.toHttpCookies() ).toString() );
		assertEquals( theKey,  theCookie.getKey() );
		assertEquals( theValue,  theCookie.getValue() );
		
		theKey = "FUNCODES";
		theValue = "5163";
		theHeaderFields.addCookie( theKey, theValue );
		LOGGER.info( new VerboseTextBuilderImpl().withElements( theHeaderFields.toHttpCookies() ).toString() );
		assertEquals( theHeaderFields.getAllCookies().size(), 3 );
		theCookie = theHeaderFields.getAllCookies().get( 2 );
		assertEquals( theKey,  theCookie.getKey() );
		assertEquals( theValue,  theCookie.getValue() );
	}
	
	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
