// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.net.impls;

import static org.junit.Assert.*;

import org.junit.Test;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.PortAlreadyBoundException;

public class PortManagerTest {

	private static final RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testBindPort() {
		Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
		LOGGER.info( "Determined port <" + thePort + "> ..." );
		assertTrue( PortManagerSingleton.getInstance().isPortBound( thePort ) );
		assertTrue( PortManagerSingleton.getInstance().isPortAvaialble( thePort ) );
		boolean isUnbound = PortManagerSingleton.getInstance().unbindPort( thePort );
		assertTrue( isUnbound );
		isUnbound = PortManagerSingleton.getInstance().unbindPort( thePort );
		assertFalse( isUnbound );
	}

	@Test
	public void testUnbindPort() {
		Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
		LOGGER.info( "Determined port <" + thePort + "> ..." );
		assertTrue( PortManagerSingleton.getInstance().isPortBound( thePort ) );
		assertTrue( PortManagerSingleton.getInstance().isPortAvaialble( thePort ) );
		try {
			PortManagerSingleton.getInstance().unbindPort( new Integer( thePort ) );
		}
		catch ( IllegalArgumentException ignore ) { /* expected */ }
	}

	@Test
	public void testPortBound() {
		Integer thePort = PortManagerSingleton.getInstance().bindAnyPort();
		LOGGER.info( "Determined port <" + thePort + "> ..." );
		try {
			PortManagerSingleton.getInstance().bindPort( thePort );
			fail( "Expecting port <" + thePort + "> to be already bound!" );
		}
		catch ( PortAlreadyBoundException ignore ) { /* expected */ }
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
