// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.net.impls;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.ContentEncoding;
import org.refcodes.net.ContentType;
import org.refcodes.net.HeaderField;
import org.refcodes.net.HeaderFields;
import org.refcodes.net.MediaType;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;

public class HeaderFieldsTest {

	private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testAcceptTypes() {
		HeaderField theHeaderField = HeaderField.ACCEPT;
		HeaderFields<?, ?> theHeaderFields = new RequestHeaderFieldsImpl();
		theHeaderFields.putAcceptTypes( MediaType.APPLICATION_JSON, MediaType.TEXT_XML );
		List<ContentType> theFields = theHeaderFields.getAcceptTypes();
		LOGGER.info( "Retrieved fields := " + new VerboseTextBuilderImpl().withElements( theFields ).toString() );
		assertEquals( theFields.size(), 2 );
		List<String> theStrings = theHeaderFields.get( theHeaderField );
		LOGGER.info( "Retrieved raw fields := " + new VerboseTextBuilderImpl().withElements( theStrings ).toString() );
		assertEquals( theStrings.size(), 1 );
		theHeaderFields.putAcceptTypes( theFields );
		List<ContentType> theElements = theHeaderFields.getAcceptTypes();
		LOGGER.info( "Re-Retrieved elements := " + new VerboseTextBuilderImpl().withElements( theElements ).toString() );
		assertEquals( theElements.size(), 2 );
		theStrings = theHeaderFields.get( theHeaderField );
		LOGGER.info( "Re-Retrieved raw fields := " + new VerboseTextBuilderImpl().withElements( theStrings ).toString() );
		assertEquals( theStrings.size(), 1 );
	}

	@Test
	public void testContentEncoding() {
		HeaderField theHeaderField = HeaderField.ACCEPT_ENCODING;
		HeaderFields<?, ?> theHeaderFields = new RequestHeaderFieldsImpl();
		theHeaderFields.putAcceptEncodings( ContentEncoding.GZIP, ContentEncoding.IDENTITY );
		List<ContentEncoding> theFields = theHeaderFields.getAcceptEncodings();
		List<ContentEncoding> theElements = theHeaderFields.getAcceptEncodings();
		assertEquals( theElements.size(), 2 );
		assertEquals( "Expecting separate fields.", "{ GZIP, IDENTITY }", new VerboseTextBuilderImpl().withElements( theElements ).toString() );
		List<String> theStrings = theHeaderFields.get( theHeaderField );
		assertEquals( theStrings.size(), 1 );
		assertEquals( "Expecting single field.", "{ \"gzip,identity\" }", new VerboseTextBuilderImpl().withElements( theStrings ).toString() );
		theHeaderFields.putAcceptEncodings( theFields );
		theElements = theHeaderFields.getAcceptEncodings();
		assertEquals( theElements.size(), 2 );
		theStrings = theHeaderFields.get( theHeaderField );
		assertEquals( theStrings.size(), 1 );
		assertEquals( "Expecting separate fields.", "{ GZIP, IDENTITY }", new VerboseTextBuilderImpl().withElements( theElements ).toString() );
		assertEquals( "Expecting single field.", "{ \"gzip,identity\" }", new VerboseTextBuilderImpl().withElements( theStrings ).toString() );
	}

	@Test
	public void testBasicAuthenticateRealm() {
		HeaderFields<?, ?> theHeaderFields = new RequestHeaderFieldsImpl();
		String theRealm = "REALM";
		theHeaderFields.putBasicAuthRequired( theRealm );
		String toRealm = theHeaderFields.toBasicAuthRealm();
		assertEquals( theRealm, toRealm );

		theRealm = "";
		theHeaderFields.putBasicAuthRequired( theRealm );
		toRealm = theHeaderFields.toBasicAuthRealm();
		assertEquals( theRealm, toRealm );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
