// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.net.impls;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.Test;
import org.refcodes.net.FormFields;
import org.refcodes.net.impls.FormFieldsImpl;

/**
 * @author steiner
 *
 */
public class FormFieldsTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testToQueryString() {
		FormFields theFields = new FormFieldsImpl();
		theFields.addTo( "elements", "1" );
		theFields.addTo( "elements", "2" );
		theFields.addTo( "elements", "3" );
		theFields.addTo( "order", "ascending" );
		assertEquals( "?elements=1&elements=2&elements=3&order=ascending", theFields.toHttpQueryString() );
	}

	@Test
	public void testFromQueryString() {
		FormFields theFields = new FormFieldsImpl();
		theFields.fromHttpQueryString( "?elements=1&elements=2&elements=3&order=ascending&guest" );
		List<String> elements = theFields.get( "elements" );
		// System.out.println( new VerboseTextBuilderImpl().withElements( elements ) );
		assertEquals( 3, elements.size() );
		assertEquals( "1", elements.get( 0 ) );
		assertEquals( "2", elements.get( 1 ) );
		assertEquals( "3", elements.get( 2 ) );
		elements = theFields.get( "order" );
		// System.out.println( new VerboseTextBuilderImpl().withElements( elements ) );
		assertEquals( 1, elements.size() );
		assertEquals( "ascending", elements.get( 0 ) );
		elements = theFields.get( "guest" );
		// System.out.println( new VerboseTextBuilderImpl().withElements( elements ) );
		assertEquals( 1, elements.size() );
		assertEquals( "", elements.get( 0 ) );
	}

	@Test
	public void testFromUrl() {
		FormFields theFields = new FormFieldsImpl();
		theFields.fromUrl( "https://www.refcodes.org/sources?elements=1&elements=2&elements=3&order=ascending&guest" );
		List<String> elements = theFields.get( "elements" );
		// System.out.println( new VerboseTextBuilderImpl().withElements( elements ) );
		assertEquals( 3, elements.size() );
		assertEquals( "1", elements.get( 0 ) );
		assertEquals( "2", elements.get( 1 ) );
		assertEquals( "3", elements.get( 2 ) );
		elements = theFields.get( "order" );
		// System.out.println( new VerboseTextBuilderImpl().withElements( elements ) );
		assertEquals( 1, elements.size() );
		assertEquals( "ascending", elements.get( 0 ) );
		elements = theFields.get( "guest" );
		// System.out.println( new VerboseTextBuilderImpl().withElements( elements ) );
		assertEquals( 1, elements.size() );
		assertEquals( "", elements.get( 0 ) );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
