// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.net.impls;

import org.junit.Test;
import org.refcodes.data.Encoding;
import org.refcodes.logger.RuntimeLogger;
import org.refcodes.logger.impls.RuntimeLoggerFactorySingleton;
import org.refcodes.net.ContentType;
import org.refcodes.net.MediaType;
import org.refcodes.net.MediaTypeParameter;

public class ContentTypeTest {

	private static RuntimeLogger LOGGER = RuntimeLoggerFactorySingleton.createRuntimeLogger();

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Test
	public void testContentType() {
		ContentType theContentType = new ContentTypeImpl( MediaType.APPLICATION_JSON );
		LOGGER.info( "Content type := " + theContentType.toHttpMediaType() );
		String theHttpMediaType = theContentType.toHttpMediaType();
		ContentType theHttpContentType = new ContentTypeImpl( theHttpMediaType );
		LOGGER.info( "HTTP content type := " + theHttpContentType.toHttpMediaType() );
	}
	
	@Test
	public void testContentTypeParameters() {
		ContentType theContentType = new ContentTypeImpl( MediaType.APPLICATION_JSON ).withPut( MediaTypeParameter.CHARSET, Encoding.UTF_8.getCode() ).withPut( "dummy", "fu" );
		LOGGER.info( "Content type := " + theContentType.toHttpMediaType() );
		String theHttpMediaType = theContentType.toHttpMediaType();
		ContentType theHttpContentType = new ContentTypeImpl( theHttpMediaType );
		LOGGER.info( "HTTP content type := " + theHttpContentType.toHttpMediaType() );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

}
