// /////////////////////////////////////////////////////////////////////////////
// REFCODES.ORG
// /////////////////////////////////////////////////////////////////////////////
// This code is copyright (c) by Siegfried Steiner, Munich, Germany and licensed
// under the following (see "http://en.wikipedia.org/wiki/Multi-licensing")
// licenses:
// -----------------------------------------------------------------------------
// GNU General Public License, v3.0 ("http://www.gnu.org/licenses/gpl-3.0.html")
// -----------------------------------------------------------------------------
// Apache License, v2.0 ("http://www.apache.org/licenses/LICENSE-2.0")
// -----------------------------------------------------------------------------
// Please contact the copyright holding author(s) of the software artifacts in
// question for licensing issues not being covered by the above listed licenses,
// also regarding commercial licensing models or regarding the compatibility
// with other open source licenses.
// /////////////////////////////////////////////////////////////////////////////

package org.refcodes.net.impls;

import static org.junit.Assert.*;

import org.junit.Before;
import org.junit.Test;
import org.refcodes.exception.MarshalException;
import org.refcodes.exception.UnmarshalException;
import org.refcodes.net.MediaTypeFactory;
import org.refcodes.textual.impls.VerboseTextBuilderImpl;

public class ApplicationJsonFactoryTest {

	// /////////////////////////////////////////////////////////////////////////
	// STATICS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// CONSTANTS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// VARIABLES:
	// /////////////////////////////////////////////////////////////////////////

	private MediaTypeFactory _facotory;

	// /////////////////////////////////////////////////////////////////////////
	// CONSTRUCTORS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INJECTION:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// METHODS:
	// /////////////////////////////////////////////////////////////////////////

	@Before
	public void setUp() {
		_facotory = new ApplicationJsonFactory();
	}

	@Test
	public void testObjectGraph() throws MarshalException, UnmarshalException {
		Person thePerson = new Person( "Nolan", "Bushnell" );
		Person theChild = new Person( "Atari", "VCS 2600" );
		thePerson.setChild( theChild );
		Car theCar = new Car( "Trabant", "Turbo 2000" );
		thePerson.setCar( theCar );
		String theBody = _facotory.toMarshaled( thePerson );
		System.out.println( theBody );
		Person theUnmarshalled = _facotory.toUnmarshaled( theBody, Person.class );
		assertEquals( thePerson, theUnmarshalled );
	}

	@Test
	public void testArray() throws MarshalException, UnmarshalException {
		String[] theArray = new String[] {
				"one", "two", "three", "four", "five", "six", "seven", "eight", "nine"
		};
		String theBody = _facotory.toMarshaled( theArray );
		System.out.println( theBody );
		String[] theUnmarshalled = _facotory.toUnmarshaled( theBody, String[].class );
		System.out.println( new VerboseTextBuilderImpl().withElements( theArray ).toString() );
		assertArrayEquals( theArray, theUnmarshalled );
	}

	// /////////////////////////////////////////////////////////////////////////
	// HOOKS:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// HELPER:
	// /////////////////////////////////////////////////////////////////////////

	// /////////////////////////////////////////////////////////////////////////
	// INNER CLASSES:
	// /////////////////////////////////////////////////////////////////////////

	public static class Person {

		private String firstName;
		private String lastName;
		private Person child = null;
		private Car car = null;

		public Car getCar() {
			return car;
		}

		public void setCar( Car car ) {
			this.car = car;
		}

		public Person getChild() {
			return child;
		}

		public void setChild( Person child ) {
			this.child = child;
		}

		public Person() {};

		public Person( String firstName, String lastName ) {
			this.firstName = firstName;
			this.lastName = lastName;
		}

		public String getFirstName() {
			return firstName;
		}

		public void setFirstName( String firstName ) {
			this.firstName = firstName;
		}

		public String getLastName() {
			return lastName;
		}

		public void setLastName( String lastName ) {
			this.lastName = lastName;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((car == null) ? 0 : car.hashCode());
			result = prime * result + ((child == null) ? 0 : child.hashCode());
			result = prime * result + ((firstName == null) ? 0 : firstName.hashCode());
			result = prime * result + ((lastName == null) ? 0 : lastName.hashCode());
			return result;
		}

		@Override
		public boolean equals( Object obj ) {
			if ( this == obj ) return true;
			if ( obj == null ) return false;
			if ( getClass() != obj.getClass() ) return false;
			Person other = (Person) obj;
			if ( car == null ) {
				if ( other.car != null ) return false;
			}
			else if ( !car.equals( other.car ) ) return false;
			if ( child == null ) {
				if ( other.child != null ) return false;
			}
			else if ( !child.equals( other.child ) ) return false;
			if ( firstName == null ) {
				if ( other.firstName != null ) return false;
			}
			else if ( !firstName.equals( other.firstName ) ) return false;
			if ( lastName == null ) {
				if ( other.lastName != null ) return false;
			}
			else if ( !lastName.equals( other.lastName ) ) return false;
			return true;
		}
	}

	public static class Car {

		private String _vendor;
		private String _model;

		public Car() {}

		public Car( String vendor, String model ) {
			this._vendor = vendor;
			this._model = model;
		}

		public String getVendor() {
			return _vendor;
		}

		public void setVendor( String vendor ) {
			this._vendor = vendor;
		}

		public String getModel() {
			return _model;
		}

		public void setModel( String model ) {
			this._model = model;
		}

		@Override
		public int hashCode() {
			final int prime = 31;
			int result = 1;
			result = prime * result + ((_model == null) ? 0 : _model.hashCode());
			result = prime * result + ((_vendor == null) ? 0 : _vendor.hashCode());
			return result;
		}

		@Override
		public boolean equals( Object obj ) {
			if ( this == obj ) return true;
			if ( obj == null ) return false;
			if ( getClass() != obj.getClass() ) return false;
			Car other = (Car) obj;
			if ( _model == null ) {
				if ( other._model != null ) return false;
			}
			else if ( !_model.equals( other._model ) ) return false;
			if ( _vendor == null ) {
				if ( other._vendor != null ) return false;
			}
			else if ( !_vendor.equals( other._vendor ) ) return false;
			return true;
		}
	}
}
