/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as.caching;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.as.ASUtils;
import org.projectodd.wunderboss.caching.Caching;
import org.projectodd.wunderboss.caching.Config;
import org.projectodd.wunderboss.caching.Encoder6;
import org.projectodd.wunderboss.caching.Encoder8;
import org.projectodd.wunderboss.caching.InfinispanCaching;
import org.projectodd.wunderboss.caching.KeyEquivalenceCache;
import org.projectodd.wunderboss.codecs.Codec;

public class ASCaching
extends InfinispanCaching {
    public static final ServiceName WEB_CACHE_MANAGER = ServiceName.JBOSS.append(new String[]{"infinispan", "web"});

    public ASCaching(String name, Options<Caching.CreateOption> options) {
        super(name, options);
        if (ASUtils.containerIsWildFly10()) {
            this.encoder = new Encoder8();
        } else if (!ASUtils.containerIsWildFly9()) {
            this.encoder = new Encoder6();
        }
        if (ASUtils.containerIsEAP6()) {
            Config.className = "org.projectodd.wunderboss.caching.Config5";
        }
    }

    public Cache withCodec(Cache cache, Codec codec) {
        Cache c = ASUtils.containerIsEAP6() ? new KeyEquivalenceCache(cache) : cache;
        return super.withCodec(c, codec);
    }

    public synchronized EmbeddedCacheManager manager() {
        if (this.manager == null) {
            this.manager = this.getWebCacheManager();
        }
        return this.manager;
    }

    protected Options<Caching.CreateOption> validate(Map<Caching.CreateOption, Object> options) {
        Options result = new Options(options);
        String mode = result.getString((Object)Caching.CreateOption.MODE);
        if (mode == null && ASUtils.inCluster()) {
            result.put((Object)Caching.CreateOption.MODE, (Object)"DIST_SYNC");
        }
        return result;
    }

    private EmbeddedCacheManager getWebCacheManager() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)WunderBoss.options().get((Object)"service-registry");
        return (EmbeddedCacheManager)serviceRegistry.getRequiredService(WEB_CACHE_MANAGER).getValue();
    }

    private GlobalConfiguration getGlobalConfiguration() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        return builder.read(this.getWebCacheManager().getCacheManagerConfiguration()).classLoader(Thread.currentThread().getContextClassLoader()).transport().clusterName("wboss").build();
    }
}

