/*
 * Decompiled with CFR 0.152.
 */
package lombok.launch;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ShadowClassLoader
extends ClassLoader {
    private static final String SELF_NAME = "lombok/launch/ShadowClassLoader.class";
    private final String SELF_BASE;
    private final File SELF_BASE_FILE;
    private final int SELF_BASE_LENGTH;
    private final List<File> override = new ArrayList<File>();
    private final String sclSuffix;
    private final List<String> parentExclusion = new ArrayList<String>();
    private static final String EMPTY_MARKER = new String("--EMPTY JAR--");
    private Map<String, Object> jarContentsCacheTrackers = new HashMap<String, Object>();
    private static WeakHashMap<Object, String> trackerCache = new WeakHashMap();
    private static WeakHashMap<Object, List<String>> jarContentsCache = new WeakHashMap();

    ShadowClassLoader(ClassLoader source, String sclSuffix) {
        this(source, sclSuffix, null, new String[0]);
    }

    ShadowClassLoader(ClassLoader source, String sclSuffix, String selfBase, String ... parentExclusion) {
        super(source);
        this.sclSuffix = sclSuffix;
        if (parentExclusion != null) {
            for (String pe : parentExclusion) {
                if (!(pe = pe.replace(".", "/")).endsWith("/")) {
                    pe = pe + "/";
                }
                this.parentExclusion.add(pe);
            }
        }
        if (selfBase != null) {
            this.SELF_BASE = selfBase;
            this.SELF_BASE_LENGTH = selfBase.length();
        } else {
            String sclClassUrl = ShadowClassLoader.class.getResource("ShadowClassLoader.class").toString();
            if (!sclClassUrl.endsWith(SELF_NAME)) {
                throw new InternalError("ShadowLoader can't find itself.");
            }
            this.SELF_BASE_LENGTH = sclClassUrl.length() - SELF_NAME.length();
            this.SELF_BASE = sclClassUrl.substring(0, this.SELF_BASE_LENGTH);
        }
        this.SELF_BASE_FILE = this.SELF_BASE.startsWith("jar:file:") && this.SELF_BASE.endsWith("!/") ? new File(this.SELF_BASE.substring(9, this.SELF_BASE.length() - 2)) : (this.SELF_BASE.startsWith("file:") ? new File(this.SELF_BASE.substring(5)) : new File(this.SELF_BASE));
        String scl = System.getProperty("shadow.override." + sclSuffix);
        if (scl != null && !scl.isEmpty()) {
            for (String part : scl.split("\\s*" + (File.pathSeparatorChar == ';' ? ";" : ":") + "\\s*")) {
                if (part.endsWith("/*") || part.endsWith(File.separator + "*")) {
                    this.addOverrideJarDir(part.substring(0, part.length() - 2));
                    continue;
                }
                this.addOverrideClasspathEntry(part);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getOrMakeJarListing(String absolutePathToJar) {
        List<String> list;
        List<String> list2 = list = this.retrieveFromCache(absolutePathToJar);
        synchronized (list2) {
            if (list.isEmpty()) {
                try {
                    JarFile jf = new JarFile(absolutePathToJar);
                    try {
                        Enumeration<JarEntry> entries = jf.entries();
                        while (entries.hasMoreElements()) {
                            JarEntry jarEntry = entries.nextElement();
                            if (jarEntry.isDirectory()) continue;
                            list.add(jarEntry.getName());
                        }
                    }
                    finally {
                        jf.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (list.isEmpty()) {
                    list.add(EMPTY_MARKER);
                }
            }
        }
        if (list.size() == 1 && list.get(0) == EMPTY_MARKER) {
            return Collections.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> retrieveFromCache(String absolutePathToJar) {
        WeakHashMap<Object, String> weakHashMap = trackerCache;
        synchronized (weakHashMap) {
            Object tracker = this.jarContentsCacheTrackers.get(absolutePathToJar);
            if (tracker != null) {
                return jarContentsCache.get(tracker);
            }
            for (Map.Entry<Object, String> entry : trackerCache.entrySet()) {
                if (!entry.getValue().equals(absolutePathToJar)) continue;
                tracker = entry.getKey();
                break;
            }
            List<String> result = null;
            if (tracker != null) {
                result = jarContentsCache.get(tracker);
            }
            if (result != null) {
                return result;
            }
            tracker = new Object();
            ArrayList<String> list = new ArrayList<String>();
            jarContentsCache.put(tracker, list);
            trackerCache.put(tracker, absolutePathToJar);
            this.jarContentsCacheTrackers.put(absolutePathToJar, tracker);
            return list;
        }
    }

    private URL getResourceFromLocation(String name, String altName, File location) {
        File absoluteFile;
        if (location.isDirectory()) {
            try {
                File f;
                if (altName != null && (f = new File(location, altName)).isFile() && f.canRead()) {
                    return f.toURI().toURL();
                }
                f = new File(location, name);
                if (f.isFile() && f.canRead()) {
                    return f.toURI().toURL();
                }
                return null;
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (!location.isFile() || !location.canRead()) {
            return null;
        }
        try {
            absoluteFile = location.getCanonicalFile();
        }
        catch (Exception e) {
            absoluteFile = location.getAbsoluteFile();
        }
        List<String> jarContents = this.getOrMakeJarListing(absoluteFile.getAbsolutePath());
        String absoluteUri = absoluteFile.toURI().toString();
        try {
            if (jarContents.contains(altName)) {
                return new URI("jar:" + absoluteUri + "!/" + altName).toURL();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (jarContents.contains(name)) {
                return new URI("jar:" + absoluteUri + "!/" + name).toURL();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return null;
    }

    private boolean inOwnBase(URL item, String name) {
        if (item == null) {
            return false;
        }
        String itemString = item.toString();
        return itemString.length() == this.SELF_BASE_LENGTH + name.length() && this.SELF_BASE.regionMatches(0, itemString, 0, this.SELF_BASE_LENGTH);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        URL fromSelf;
        String altName = null;
        if (name.endsWith(".class")) {
            altName = name.substring(0, name.length() - 6) + ".SCL." + this.sclSuffix;
        }
        Vector<URL> vector = new Vector<URL>();
        for (File ce : this.override) {
            URL url = this.getResourceFromLocation(name, altName, ce);
            if (url == null) continue;
            vector.add(url);
        }
        if (this.override.isEmpty() && (fromSelf = this.getResourceFromLocation(name, altName, this.SELF_BASE_FILE)) != null) {
            vector.add(fromSelf);
        }
        Enumeration<URL> sec = super.getResources(name);
        while (sec.hasMoreElements()) {
            URL item = sec.nextElement();
            if (this.inOwnBase(item, name)) continue;
            vector.add(item);
        }
        if (altName != null) {
            Enumeration<URL> tern = super.getResources(altName);
            while (tern.hasMoreElements()) {
                URL item = tern.nextElement();
                if (this.inOwnBase(item, altName)) continue;
                vector.add(item);
            }
        }
        return vector.elements();
    }

    @Override
    public URL getResource(String name) {
        return this.getResource_(name, false);
    }

    private URL getResource_(String name, boolean noSuper) {
        URL res;
        String altName = null;
        if (name.endsWith(".class")) {
            altName = name.substring(0, name.length() - 6) + ".SCL." + this.sclSuffix;
        }
        for (File ce : this.override) {
            URL url = this.getResourceFromLocation(name, altName, ce);
            if (url == null) continue;
            return url;
        }
        if (!this.override.isEmpty()) {
            if (noSuper) {
                return null;
            }
            if (altName != null) {
                try {
                    URL res2 = this.getResourceSkippingSelf(altName);
                    if (res2 != null) {
                        return res2;
                    }
                }
                catch (IOException ignore) {
                    // empty catch block
                }
            }
            try {
                return this.getResourceSkippingSelf(name);
            }
            catch (IOException e) {
                return null;
            }
        }
        URL url = this.getResourceFromLocation(name, altName, this.SELF_BASE_FILE);
        if (url != null) {
            return url;
        }
        if (altName != null && (res = super.getResource(altName)) != null && (!noSuper || this.inOwnBase(res, altName))) {
            return res;
        }
        res = super.getResource(name);
        if (res != null && (!noSuper || this.inOwnBase(res, name))) {
            return res;
        }
        return null;
    }

    private boolean exclusionListMatch(String name) {
        for (String pe : this.parentExclusion) {
            if (!name.startsWith(pe)) continue;
            return true;
        }
        return false;
    }

    private URL getResourceSkippingSelf(String name) throws IOException {
        URL candidate = super.getResource(name);
        if (candidate == null) {
            return null;
        }
        if (!this.inOwnBase(candidate, name)) {
            return candidate;
        }
        Enumeration<URL> en = super.getResources(name);
        while (en.hasMoreElements()) {
            candidate = en.nextElement();
            if (this.inOwnBase(candidate, name)) continue;
            return candidate;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        byte[] b;
        Class<?> alreadyLoaded = this.findLoadedClass(name);
        if (alreadyLoaded != null) {
            return alreadyLoaded;
        }
        String fileNameOfClass = name.replace(".", "/") + ".class";
        URL res = this.getResource_(fileNameOfClass, true);
        if (res == null) {
            if (!this.exclusionListMatch(fileNameOfClass)) {
                return super.loadClass(name, resolve);
            }
            throw new ClassNotFoundException(name);
        }
        int p = 0;
        try {
            InputStream in = res.openStream();
            try {
                int r;
                b = new byte[65536];
                while ((r = in.read(b, p, b.length - p)) != -1) {
                    if ((p += r) != b.length) continue;
                    byte[] nb = new byte[b.length * 2];
                    System.arraycopy(b, 0, nb, 0, p);
                    b = nb;
                }
            }
            finally {
                in.close();
            }
        }
        catch (IOException e) {
            throw new ClassNotFoundException("I/O exception reading class " + name, e);
        }
        Class<?> c = this.defineClass(name, b, 0, p);
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public void addOverrideJarDir(String dir) {
        File f = new File(dir);
        for (File j : f.listFiles()) {
            if (!j.getName().toLowerCase().endsWith(".jar") || !j.canRead() || !j.isFile()) continue;
            this.override.add(j);
        }
    }

    public void addOverrideClasspathEntry(String entry) {
        this.override.add(new File(entry));
    }
}

