/*
 * Decompiled with CFR 0.152.
 */
package lombok.javac;

import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Collection;
import lombok.core.ImportList;

public class JavacImportList
implements ImportList {
    private final JCTree.JCExpression pkg;
    private final List<JCTree> defs;

    public JavacImportList(JCTree.JCCompilationUnit cud) {
        this.pkg = cud.pid;
        this.defs = cud.defs;
    }

    @Override
    public String getFullyQualifiedNameForSimpleName(String unqualified) {
        for (JCTree def : this.defs) {
            String simpleName;
            JCTree.JCFieldAccess qual;
            if (!(def instanceof JCTree.JCImport) || !((qual = ((JCTree.JCImport)def).qualid) instanceof JCTree.JCFieldAccess) || !(simpleName = qual.name.toString()).equals(unqualified)) continue;
            return qual.toString();
        }
        return null;
    }

    @Override
    public boolean hasStarImport(String packageName) {
        if (this.pkg != null && this.pkg.toString().equals(packageName)) {
            return true;
        }
        if ("java.lang".equals(packageName)) {
            return true;
        }
        for (JCTree def : this.defs) {
            String simpleName;
            JCTree.JCFieldAccess qual;
            if (!(def instanceof JCTree.JCImport) || ((JCTree.JCImport)def).staticImport || !((qual = ((JCTree.JCImport)def).qualid) instanceof JCTree.JCFieldAccess) || !"*".equals(simpleName = qual.name.toString()) || !packageName.equals(qual.selected.toString())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<String> applyNameToStarImports(String startsWith, String name) {
        ArrayList<String> out = new ArrayList<String>();
        if (this.pkg != null && this.topLevelName(this.pkg).equals(startsWith)) {
            out.add(this.pkg.toString() + "." + name);
        }
        for (JCTree def : this.defs) {
            String topLevelName;
            String simpleName;
            JCTree.JCFieldAccess qual;
            if (!(def instanceof JCTree.JCImport) || ((JCTree.JCImport)def).staticImport || !((qual = ((JCTree.JCImport)def).qualid) instanceof JCTree.JCFieldAccess) || !"*".equals(simpleName = qual.name.toString()) || !(topLevelName = this.topLevelName(qual)).equals(startsWith)) continue;
            out.add(qual.selected.toString() + "." + name);
        }
        return out;
    }

    private String topLevelName(JCTree tree) {
        while (tree instanceof JCTree.JCFieldAccess) {
            tree = ((JCTree.JCFieldAccess)tree).selected;
        }
        return tree.toString();
    }

    @Override
    public String applyUnqualifiedNameToPackage(String unqualified) {
        if (this.pkg == null) {
            return unqualified;
        }
        return this.pkg.toString() + "." + unqualified;
    }
}

