/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.extensions.ckeditor;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class ResourceModifier {
    private static final String PROJECT_DIRECTORY = System.getProperty("user.dir");

    public static void main(String[] args) throws IOException {
        String resourcesDirectory = PROJECT_DIRECTORY + "/src/main/resources/META-INF/resources/primefaces-extensions/";
        System.err.println("######## Modify skin styles....");
        File skinsPath = new File(PROJECT_DIRECTORY + "/src/main/resources/META-INF/resources/primefaces-extensions/ckeditor/skins/");
        for (String skin : skinsPath.list()) {
            System.err.println("#### Modify skin '" + skin + "'");
            File skinDirectory = new File(resourcesDirectory + "ckeditor/skins/" + skin);
            String relativeSkinPath = StringUtils.replace((String)StringUtils.replace((String)skinDirectory.getPath(), (String)resourcesDirectory, (String)""), (String)"\\", (String)"/");
            for (File resourceToModify : skinDirectory.listFiles()) {
                if (!resourceToModify.getName().endsWith(".css")) continue;
                System.err.println("## Modify file '" + resourceToModify.getName() + "'");
                String fileContent = FileUtils.readFileToString((File)resourceToModify);
                List<File> allSkinResources = ResourceModifier.getResourcesList(skinDirectory);
                for (File resource : allSkinResources) {
                    if (resource.getName().endsWith(".css")) continue;
                    String relativeResourcePath = StringUtils.replace((String)StringUtils.replace((String)resource.getPath(), (String)resourcesDirectory, (String)""), (String)"\\", (String)"/");
                    String resourceName = StringUtils.replace((String)resource.getAbsolutePath().replace(skinDirectory.getAbsolutePath(), ""), (String)"\\", (String)"/");
                    if (resourceName.startsWith("/")) {
                        resourceName = resourceName.substring(1);
                    }
                    fileContent = fileContent.replaceAll("url\\(" + resourceName + "\\)", "url\\(\"#{resource['primefaces-extensions:" + relativeResourcePath + "']}\"\\)");
                }
                fileContent = fileContent.replaceAll("url\\(icons.png\\?t=GAGE", "url\\(\"#{resource['primefaces-extensions:" + relativeSkinPath + "/icons.png']}&t=GAGE\"");
                fileContent = fileContent.replaceAll("url\\(icons_hidpi.png\\?t=GAGE", "url\\(\"#{resource['primefaces-extensions:" + relativeSkinPath + "/icons_hidpi.png']}&t=GAGE\"");
                FileUtils.writeStringToFile((File)resourceToModify, (String)fileContent);
            }
            String fileContent = "";
            File file = null;
            file = new File(PROJECT_DIRECTORY + "/src/main/resources/META-INF/resources/primefaces-extensions/ckeditor/plugins/smiley/dialogs/smiley.js");
            fileContent = FileUtils.readFileToString((File)file).replaceAll("CKEDITOR.tools.htmlEncode\\(e\\.smiley_path\\+h\\[a\\]\\)", "CKEDITOR.tools.htmlEncode\\(CKEDITOR.getUrl\\(e\\.smiley_path\\+h\\[a\\]\\)\\)");
            FileUtils.writeStringToFile((File)file, (String)fileContent);
        }
        String fileContent = "";
        File file = null;
        file = new File(resourcesDirectory + "ckeditor/ckeditor.js");
        fileContent = FileUtils.readFileToString((File)file).replaceAll("this.path\\+\"styles/copyformatting.css\"", "CKEDITOR.getUrl(this.path\\+\"styles/copyformatting.css\")");
        FileUtils.writeStringToFile((File)file, (String)fileContent);
        file = new File(resourcesDirectory + "ckeditor/ckeditor.js");
        fileContent = FileUtils.readFileToString((File)file).replaceAll("this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/scayt.css\"", "CKEDITOR.getUrl(this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/scayt.css\")");
        FileUtils.writeStringToFile((File)file, (String)fileContent);
        file = new File(resourcesDirectory + "ckeditor/ckeditor.js");
        fileContent = FileUtils.readFileToString((File)file).replaceAll("this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/wsc.css\"", "CKEDITOR.getUrl(this.path\\+\"skins/\"\\+CKEDITOR.skin.name\\+\"/wsc.css\")");
        FileUtils.writeStringToFile((File)file, (String)fileContent);
    }

    private static List<File> getResourcesList(File file) {
        ArrayList<File> result = new ArrayList<File>();
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                result.addAll(ResourceModifier.getResourcesList(f));
            }
        } else if (file.getName().endsWith(".png") || file.getName().endsWith(".css")) {
            result.add(file);
        }
        return result;
    }
}

