/*
 * Decompiled with CFR 0.152.
 */
package org.ploin.web.flow;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.ploin.web.flow.Flow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowControl
implements Serializable {
    private static final long serialVersionUID = -6940069522385802482L;
    private static Log log = LogFactory.getLog(FlowControl.class);
    public static final String PLOIN_FLOWS = "ploinFlows";
    public static final String PLOIN_PLOIN = "ploinploin";
    public static final String PLOIN_FACES_TIME = "ploinFacesTime";
    public static final String PLOIN_FACES_FROM_VIEW_ID = "ploinFacesFromViewId";
    public static final String PLOIN_FACES_FLOW_PATH = "ploinFacesFlowPath";
    public static final String JSF_PHASE = "jsfPhase";
    public static final String LIFECYCLE_ID = "lifecycleId";

    public List<Flow> readFlows() {
        ArrayList<Flow> flows = new ArrayList<Flow>();
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader == null) {
                loader = ClassLoader.getSystemClassLoader();
            }
            URL url = loader.getResource("ploinFlows.xml");
            SAXReader reader = new SAXReader();
            Document document = reader.read(url);
            Element root = document.getRootElement();
            String authSource = null;
            String appName = null;
            String acceddDeniedPage = null;
            Boolean disableUrlNavigation = Boolean.FALSE;
            HashSet<String> viewsForAllFlows = new HashSet<String>();
            HashSet<String> ignoreFlows = new HashSet<String>();
            Iterator i = root.elementIterator();
            while (i.hasNext()) {
                Element view;
                Iterator e;
                Element flow = (Element)i.next();
                if ("ignoreViews".equalsIgnoreCase(flow.getName())) {
                    e = flow.elementIterator();
                    while (e.hasNext()) {
                        view = (Element)e.next();
                        if (!"view".equalsIgnoreCase(view.getName())) continue;
                        ignoreFlows.add(view.getStringValue());
                    }
                    continue;
                }
                if ("viewsForAllFlows".equalsIgnoreCase(flow.getName())) {
                    e = flow.elementIterator();
                    while (e.hasNext()) {
                        view = (Element)e.next();
                        if (!"view".equalsIgnoreCase(view.getName())) continue;
                        viewsForAllFlows.add(view.getStringValue());
                    }
                    continue;
                }
                if ("disableUrlNavigation".equalsIgnoreCase(flow.getName())) {
                    try {
                        disableUrlNavigation = Boolean.parseBoolean(flow.getStringValue());
                    }
                    catch (Exception e2) {
                        log.error((Object)"ERROR by parsing boolean. ", (Throwable)e2);
                    }
                    continue;
                }
                if ("accessDeniedPage".equalsIgnoreCase(flow.getName())) {
                    acceddDeniedPage = flow.getStringValue();
                    continue;
                }
                if ("appName".equalsIgnoreCase(flow.getName())) {
                    appName = flow.getStringValue();
                    continue;
                }
                if ("authoritySource".equalsIgnoreCase(flow.getName())) {
                    authSource = flow.getStringValue();
                    continue;
                }
                if (!"flow".equalsIgnoreCase(flow.getName())) continue;
                Flow flowItem = new Flow();
                flowItem.setFlowId(flow.attribute("id").getValue());
                log.debug((Object)("read ID: " + flow.attribute("id").getValue()));
                Iterator e3 = flow.elementIterator();
                while (e3.hasNext()) {
                    Element auth;
                    Iterator t;
                    Element flowChild = (Element)e3.next();
                    if ("views".equalsIgnoreCase(flowChild.getName())) {
                        t = flowChild.elementIterator();
                        while (t.hasNext()) {
                            Element view2 = (Element)t.next();
                            if (!"view".equalsIgnoreCase(view2.getName())) continue;
                            flowItem.addView(view2.getStringValue());
                        }
                        continue;
                    }
                    if ("attributes".equalsIgnoreCase(flowChild.getName())) {
                        t = flowChild.elementIterator();
                        while (t.hasNext()) {
                            Element attribute = (Element)t.next();
                            if (!"attribute".equalsIgnoreCase(attribute.getName())) continue;
                            flowItem.addAttribute(attribute.getStringValue());
                        }
                        continue;
                    }
                    if ("includeAuthorities".equalsIgnoreCase(flowChild.getName()) || "includeAuthoritys".equalsIgnoreCase(flowChild.getName())) {
                        t = flowChild.elementIterator();
                        while (t.hasNext()) {
                            auth = (Element)t.next();
                            if (!"authority".equalsIgnoreCase(auth.getName())) continue;
                            flowItem.addIncludeAuthority(auth.getStringValue());
                        }
                        continue;
                    }
                    if ("excludeAuthorities".equalsIgnoreCase(flowChild.getName()) || "excludeAuthoritys".equalsIgnoreCase(flowChild.getName())) {
                        t = flowChild.elementIterator();
                        while (t.hasNext()) {
                            auth = (Element)t.next();
                            if (!"authority".equalsIgnoreCase(auth.getName())) continue;
                            flowItem.addExcludeAuthority(auth.getStringValue());
                        }
                        continue;
                    }
                    if ("beforeFlowAction".equalsIgnoreCase(flowChild.getName())) {
                        flowItem.setBeforeFlowAction(flowChild.getStringValue());
                        continue;
                    }
                    if ("afterFlowAction".equalsIgnoreCase(flowChild.getName())) {
                        flowItem.setAfterFlowAction(flowChild.getStringValue());
                        continue;
                    }
                    if ("beforeLifecycleAction".equalsIgnoreCase(flowChild.getName())) {
                        flowItem.setBeforeLifecycleAction(flowChild.getStringValue());
                        continue;
                    }
                    if ("afterLifecycleAction".equalsIgnoreCase(flowChild.getName())) {
                        flowItem.setAfterLifecycleAction(flowChild.getStringValue());
                        continue;
                    }
                    if (!"subFlows".equalsIgnoreCase(flowChild.getName())) continue;
                    t = flowChild.elementIterator();
                    while (t.hasNext()) {
                        Element flowId = (Element)t.next();
                        if (!"flowId".equalsIgnoreCase(flowId.getName())) continue;
                        flowItem.addSubFlow(flowId.getStringValue());
                    }
                }
                flowItem.setAuthoritySource(authSource);
                flowItem.setAppName(appName);
                flowItem.setAccessDeniedPage(acceddDeniedPage);
                if (viewsForAllFlows.size() > 0) {
                    for (String view3 : viewsForAllFlows) {
                        flowItem.addView(view3);
                    }
                }
                flowItem.setIgnoreViews(ignoreFlows);
                flowItem.setDisableUrlNavigation(disableUrlNavigation);
                flows.add(flowItem);
            }
        }
        catch (Exception e) {
            log.error((Object)"ERROR in ploinFlow ", (Throwable)e);
        }
        return flows;
    }

    public boolean isViewInSet(Set<String> set, String view) {
        if (view == null) {
            log.debug((Object)"isViewInSet() view is null");
            return false;
        }
        if (set == null) {
            log.debug((Object)"set is null");
            return false;
        }
        if (set.contains(view)) {
            return true;
        }
        for (String v : set) {
            Pattern pattern;
            Matcher matcher;
            if (!v.contains(".*") || !(matcher = (pattern = Pattern.compile(v)).matcher(view)).find()) continue;
            return true;
        }
        return false;
    }

    public boolean isLeavingFlow(Set<String> set, String fromViewId, String toViewId) {
        boolean fromViewIdInFlow = this.isViewInSet(set, fromViewId);
        boolean toViewIdInFlow = this.isViewInSet(set, toViewId);
        return fromViewIdInFlow && !toViewIdInFlow;
    }

    public boolean isStayInFlow(Set<String> set, String fromViewId, String toViewId) {
        boolean fromViewIdInFlow = this.isViewInSet(set, fromViewId);
        boolean toViewIdInFlow = this.isViewInSet(set, toViewId);
        return fromViewIdInFlow && toViewIdInFlow;
    }

    public boolean isViewInSubFlows(List<Flow> flows, Flow actualFlow, String goToViewId) {
        if (flows == null || flows.size() == 0) {
            log.debug((Object)" flows is empty in isViewInSubFlows");
            return false;
        }
        if (actualFlow == null) {
            log.debug((Object)" actualFlow is null in isViewInSubFlows");
            return false;
        }
        if (goToViewId == null || "".equals(goToViewId.trim())) {
            log.debug((Object)" goToViewId is null in isViewInSubFlows");
            return false;
        }
        if (actualFlow.getSubFlows() == null || actualFlow.getSubFlows().size() == 0) {
            return false;
        }
        for (Flow flow : flows) {
            for (String subflowId : actualFlow.getSubFlows()) {
                if (!flow.getFlowId().equals(subflowId) || !this.isViewInSet(flow.getViews(), goToViewId)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isViewInFlowPathPeek(List<Flow> flows, String flowId, String goToViewId) {
        if (flows == null || flows.size() == 0) {
            log.debug((Object)" flows is empty in isViewInFlowPath");
            return false;
        }
        if (flowId == null) {
            log.debug((Object)" flowId is null in isViewInFlowPath");
            return false;
        }
        if (goToViewId == null) {
            log.debug((Object)" goToViewId is null in isViewInFlowPath");
            return false;
        }
        for (Flow flow : flows) {
            if (!flowId.equals(flow.getFlowId()) || !this.isViewInSet(flow.getViews(), goToViewId)) continue;
            return true;
        }
        return false;
    }

    public String getFlowIdForViewInFlowPath(List<Flow> flows, Set<String> flowPath, String goToViewId) {
        for (Flow flow : flows) {
            for (String flowPathId : flowPath) {
                if (!flowPathId.equals(flow.getFlowId()) || !this.isViewInSet(flow.getViews(), goToViewId)) continue;
                return flow.getFlowId();
            }
        }
        return null;
    }

    public boolean isViewInFlowPath(List<Flow> flows, Set<String> flowPath, String goToViewId) {
        return this.getFlowIdForViewInFlowPath(flows, flowPath, goToViewId) != null;
    }

    public Flow getFlowById(String flowId, List<Flow> flows) {
        if (flowId == null || "".equals(flowId.trim())) {
            log.debug((Object)"flowId is null, in getFlowById");
            return null;
        }
        if (flows == null || flows.size() == 0) {
            log.debug((Object)"flows are empty, in getFlowById");
            return null;
        }
        for (Flow flow : flows) {
            if (!flow.getFlowId().equals(flowId)) continue;
            return flow;
        }
        return null;
    }

    public void leaveFlow(List<Flow> flows, String flowId, FacesContext fc, HttpSession session) {
        for (Flow flow : flows) {
            if (!flow.getFlowId().equals(flowId)) continue;
            this.leaveFlow(flow, fc, session);
            break;
        }
    }

    public void leaveFlow(Flow flow, FacesContext fc, HttpSession session) {
        if (flow != null && fc != null && session != null) {
            String action = flow.getAfterFlowAction();
            if (action != null) {
                log.debug((Object)(" execute afterFlowAction " + action));
                fc.getApplication().createValueBinding(action).getValue(fc);
            }
            for (String att : flow.getAttributes()) {
                session.removeAttribute(att);
                log.debug((Object)("remove from session: " + att + ", because leaving flow with id: " + flow.getFlowId()));
            }
        }
    }
}

